/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.model;

import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.model.Resource;
import com.dubture.symfony.index.SymfonyIndexer;
import com.dubture.symfony.index.handler.IResourceHandler;
import com.dubture.symfony.index.model.RoutingResource;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.core.IScriptProject;

public class SymfonyResourceAccess {
    private static SymfonyResourceAccess instance = null;
    private SymfonyIndexer index;

    private SymfonyResourceAccess() {
        try {
            this.index = SymfonyIndexer.getInstance();
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public static SymfonyResourceAccess getDefault() {
        if (instance == null) {
            instance = new SymfonyResourceAccess();
        }
        return instance;
    }

    public List<Resource> getResources(IScriptProject project) {
        final ArrayList<Resource> resources = new ArrayList<Resource>();
        this.index.findResources(project.getPath(), new IResourceHandler(){

            public void handle(RoutingResource resource) {
                Resource r = new Resource();
                r.type = Resource.ROUTE_RESOURCE;
                r.path = resource.getPath();
                r.prefix = resource.getPrefix();
                resources.add(r);
            }
        });
        return resources;
    }
}

