/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.model;

import com.dubture.symfony.core.log.Logger;

public class ViewPath {
    private String bundle;
    private String controller;
    private String template;
    private boolean basePath = false;
    private boolean _isRoot = false;

    public ViewPath(String path) {
        if (!path.contains(":")) {
            return;
        }
        if (path.startsWith("::")) {
            this.template = path.replace("::", "");
            this._isRoot = true;
        } else if (path.endsWith("::")) {
            this.bundle = path.replace("::", "");
            this.controller = null;
            this.template = "";
        } else {
            String[] parts = path.split(":");
            switch (parts.length) {
                case 1: {
                    this.bundle = parts[0];
                    if (this.bundle == null || this.bundle.length() != 0) break;
                    this.bundle = null;
                    break;
                }
                case 2: {
                    this.bundle = parts[0];
                    this.controller = parts[1];
                    break;
                }
                case 3: {
                    this.bundle = parts[0];
                    this.controller = parts[1];
                    if (this.controller != null && this.controller.length() == 0) {
                        this.controller = null;
                        this.basePath = true;
                    }
                    this.template = parts[2];
                    break;
                }
                default: {
                    Logger.debugMSG("Unable to parse viewpath: " + path);
                }
            }
        }
    }

    public String getBundle() {
        return this.bundle;
    }

    public String getController() {
        return this.controller;
    }

    public String getTemplate() {
        return this.template;
    }

    public String toString() {
        return String.format("%s:%s:%s", this.bundle, this.controller, this.template);
    }

    public boolean isBundleBasePath() {
        return this.basePath;
    }

    public boolean isRoot() {
        return this._isRoot;
    }

    public boolean isValid() {
        if (this.isBundleBasePath() || this.isRoot()) {
            return true;
        }
        return this.bundle != null && this.controller != null && this.template != null;
    }
}

