/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.parser;

import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.parser.IConfigParser;
import com.dubture.symfony.core.parser.PositionalXMLReader;
import com.dubture.symfony.index.model.Route;
import com.dubture.symfony.index.model.Service;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLConfigParser
implements IConfigParser {
    private XPath xPath;
    private Document doc;
    private HashMap<String, String> parameters;
    private HashMap<String, Service> services;
    private Stack<Route> routes = new Stack();

    public XMLConfigParser(InputStream inputStream) throws Exception {
        this.doc = PositionalXMLReader.readXML(inputStream);
        this.xPath = XPathFactory.newInstance().newXPath();
        this.parameters = new HashMap();
        this.services = new HashMap();
    }

    @Override
    public void parse() throws Exception {
        this.parseParameters();
        this.parseServices();
        this.parseAliases();
        this.parseSynthetic();
        this.parseRoutes();
    }

    private void parseRoutes() {
        try {
            String servicePath = "/routes/route";
            NodeList routeNodes = this.getNodes(servicePath);
            int i = 0;
            while (i < routeNodes.getLength()) {
                Node node = routeNodes.item(i);
                NamedNodeMap atts = node.getAttributes();
                String name = null;
                String pattern = null;
                int j = 0;
                while (j < atts.getLength()) {
                    Attr attr = (Attr)atts.item(j);
                    String key = attr.getName();
                    if (key.equals("id")) {
                        name = attr.getValue();
                    } else if (key.equals("pattern")) {
                        pattern = attr.getValue();
                    }
                    ++j;
                }
                XPathExpression expr = this.xPath.compile("default[@key='_controller']");
                Object _default = expr.evaluate(node, XPathConstants.NODESET);
                NodeList defaults = (NodeList)_default;
                if (defaults.getLength() == 1) {
                    Node controllerNode = defaults.item(0);
                    this.routes.push(new Route(name, pattern, controllerNode.getTextContent()));
                }
                ++i;
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    private void parseParameters() throws Exception {
        String expr = "/container/parameters/parameter[@key]";
        XPathExpression xpathExpr = this.xPath.compile(expr);
        Object result = xpathExpr.evaluate(this.doc, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            NamedNodeMap atts = node.getAttributes();
            int j = 0;
            while (j < atts.getLength()) {
                Attr attr = (Attr)atts.item(j);
                if (attr != null && attr.getName() != null && attr.getName().equals("key")) {
                    this.parameters.put(attr.getValue(), node.getTextContent());
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseServices() throws Exception {
        NodeList nodeList = this.doc.getElementsByTagName("service");
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            NamedNodeMap attributes = childNode.getAttributes();
            Node idItem = attributes.getNamedItem("id");
            if (idItem != null) {
                String id = idItem.getNodeValue();
                String phpClass = null;
                Node namedItem = attributes.getNamedItem("class");
                if (namedItem != null) {
                    phpClass = namedItem.getNodeValue();
                } else {
                    Logger.log(201, "Unable to parse class attribute from service " + childNode);
                }
                Node publicItem = attributes.getNamedItem("public");
                String _public = null;
                if (publicItem != null) {
                    _public = attributes.getNamedItem("public").getNodeValue();
                }
                if (phpClass != null && id != null) {
                    Service _service = null;
                    if (phpClass.startsWith("%") && phpClass.endsWith("%")) {
                        String placeHolder = phpClass.replace("%", "");
                        for (String key : this.getParameters().keySet()) {
                            String val = this.getParameters().get(key);
                            if (!placeHolder.equals(key)) continue;
                            _service = new Service(id, val, null);
                        }
                    } else {
                        _service = new Service(id, phpClass, null);
                    }
                    NodeList children = childNode.getChildNodes();
                    ArrayList<Node> tags = new ArrayList<Node>();
                    ArrayList<Node> arguments = new ArrayList<Node>();
                    ArrayList<Node> calls = new ArrayList<Node>();
                    int j = 0;
                    while (j < children.getLength()) {
                        Node child = children.item(j);
                        if ("tag".equals(child.getNodeName())) {
                            tags.add(child);
                        } else if ("argument".equals(child.getNodeName())) {
                            arguments.add(child);
                        } else if ("call".equals(child.getNodeName())) {
                            calls.add(child);
                        }
                        ++j;
                    }
                    if (_service != null) {
                        _service.setPublic(_public);
                        _service.setLine(Integer.valueOf(Integer.parseInt((String)childNode.getUserData("lineNumber"))));
                        for (Node tag : tags) {
                            NamedNodeMap map = tag.getAttributes();
                            Node tagName = map.getNamedItem("name");
                            if (tagName == null || tagName.getNodeValue() == null) continue;
                            _service.addTag(tagName.getNodeValue());
                        }
                    }
                    HashMap<String, Service> hashMap = this.services;
                    synchronized (hashMap) {
                        this.services.put(id, _service);
                    }
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAliases() throws Exception {
        String servicePath = "/container/services/service[@alias]";
        NodeList serviceNodes = this.getNodes(servicePath);
        int i = 0;
        while (i < serviceNodes.getLength()) {
            Element service = (Element)serviceNodes.item(i);
            String id = service.getAttribute("id");
            String alias = service.getAttribute("alias");
            if (alias != null && id != null) {
                HashMap<String, Service> hashMap = this.services;
                synchronized (hashMap) {
                    Iterator<String> it = this.services.keySet().iterator();
                    HashMap<String, Service> newServices = new HashMap<String, Service>();
                    while (it.hasNext()) {
                        String aliasID = it.next();
                        Service _s = this.services.get(aliasID);
                        if (_s == null) continue;
                        _s.addAlias(aliasID);
                        if (!alias.equals(aliasID)) continue;
                        newServices.put(id, _s);
                    }
                    this.services.putAll(newServices);
                }
            }
            ++i;
        }
    }

    private void parseSynthetic() throws Exception {
        String servicePath = "/container/services/service[@synthetic]";
        NodeList serviceNodes = this.getNodes(servicePath);
        int i = 0;
        while (i < serviceNodes.getLength()) {
            Element service = (Element)serviceNodes.item(i);
            String id = service.getAttribute("id");
            String isSynthetic = service.getAttribute("synthetic");
            if (isSynthetic != null && id != null) {
                this.services.put(id, new Service(id, "synthetic", null));
            }
            ++i;
        }
    }

    private NodeList getNodes(String path) throws Exception {
        XPathExpression xpathExpr = this.xPath.compile(path);
        Object result = xpathExpr.evaluate(this.doc, XPathConstants.NODESET);
        return (NodeList)result;
    }

    @Override
    public HashMap<String, Service> getServices() {
        return this.services;
    }

    public boolean hasServices() {
        return this.services.size() > 0;
    }

    public HashMap<String, String> getParameters() {
        return this.parameters;
    }

    public boolean hasRoutes() {
        return this.routes.size() > 0;
    }

    public Stack<Route> getRoutes() {
        return this.routes;
    }
}

