/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.parser;

import com.dubture.symfony.core.parser.IConfigParser;
import com.dubture.symfony.index.model.Service;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;

public class YamlConfigParser
implements IConfigParser {
    private InputStream input;
    private HashMap<String, Service> services = new HashMap();
    private HashMap<String, String> parameters = new HashMap();

    public YamlConfigParser(InputStream input) {
        this.input = input;
    }

    public HashMap<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public void parse() throws Exception {
        Object services;
        Pattern replaceCharPattern = Pattern.compile("%", 4);
        StringBuilder text = new StringBuilder();
        String NL = System.getProperty("line.separator");
        try (Scanner scanner = new Scanner(this.input);){
            while (scanner.hasNextLine()) {
                text.append(String.valueOf(scanner.nextLine()) + NL);
            }
        }
        Matcher m = replaceCharPattern.matcher(text);
        String tokenString = m.replaceAll("_");
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(tokenString);
        Object parameters = map.get("parameters");
        if (parameters instanceof Map) {
            this.parseParameters((Map)parameters);
        }
        if ((services = map.get("services")) instanceof Map) {
            this.parseServices((Map)services);
        }
    }

    private void parseParameters(Map parameters) {
        for (Map.Entry pairs : parameters.entrySet()) {
            String paramName = (String)pairs.getKey();
            if (paramName == null || !paramName.endsWith(".class")) continue;
            String className = (String)pairs.getValue();
            assert (className != null);
            String id = paramName.replace(".class", "");
            this.parameters.put(id, className);
        }
    }

    private void parseServices(Map services) {
        for (Map.Entry pairs : services.entrySet()) {
            String clazz;
            String id = (String)pairs.getKey();
            Map description = (Map)pairs.getValue();
            if (id == null || description == null || (clazz = (String)description.get("class")) == null || clazz.startsWith("_") && clazz.endsWith("_") && (clazz = this.parameters.get(id)) == null) continue;
            Service s = new Service(id, clazz, null);
            this.services.put(id, s);
        }
    }

    @Override
    public HashMap<String, Service> getServices() {
        return this.services;
    }
}

