/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.parser;

import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.index.model.Route;
import com.dubture.symfony.index.model.RoutingResource;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;

public class YamlRoutingParser {
    private InputStream input;
    private Stack<Route> routes = new Stack();
    private Stack<RoutingResource> resources = new Stack();

    public Stack<Route> getRoutes() {
        return this.routes;
    }

    public Stack<RoutingResource> getResources() {
        return this.resources;
    }

    public YamlRoutingParser(InputStream input) {
        this.input = input;
    }

    public void parse() {
        Pattern replaceCharPattern = Pattern.compile("%", 4);
        StringBuilder text = new StringBuilder();
        String NL = System.getProperty("line.separator");
        try (Scanner scanner = new Scanner(this.input);){
            while (scanner.hasNextLine()) {
                text.append(String.valueOf(scanner.nextLine()) + NL);
            }
        }
        Matcher m = replaceCharPattern.matcher(text);
        String tokenString = m.replaceAll("_");
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(tokenString);
        if (map == null) {
            Logger.log(2, "Unable to load yaml file " + tokenString);
            return;
        }
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (key.getClass() != String.class || value.getClass() != LinkedHashMap.class) continue;
            try {
                String name = (String)key;
                LinkedHashMap params = (LinkedHashMap)value;
                String pattern = (String)params.get("pattern");
                if (params.containsKey("resource")) {
                    String resource = (String)params.get("resource");
                    String type = (String)params.get("type");
                    String prefix = (String)params.get("prefix");
                    this.resources.add(new RoutingResource(type, resource, prefix));
                    continue;
                }
                LinkedHashMap defaults = (LinkedHashMap)params.get("defaults");
                if (defaults == null) continue;
                String viewPath = (String)defaults.get("_controller");
                this.routes.push(new Route(name, pattern, viewPath));
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
    }
}

