/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.parser;

import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;

public class YamlTranslationParser {
    private InputStream input;
    private Map<String, String> transUnits = new HashMap<String, String>();

    public YamlTranslationParser(InputStream input) {
        this.input = input;
    }

    public void parse() {
        Pattern replaceCharPattern = Pattern.compile("%", 4);
        StringBuilder text = new StringBuilder();
        String NL = System.getProperty("line.separator");
        try (Scanner scanner = new Scanner(this.input);){
            while (scanner.hasNextLine()) {
                text.append(String.valueOf(scanner.nextLine()) + NL);
            }
        }
        Matcher m = replaceCharPattern.matcher(text);
        String tokenString = m.replaceAll("_");
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(tokenString);
        if (map == null) {
            return;
        }
        for (String key : map.keySet()) {
            Object value = map.get(key);
            this.parse(key, value);
        }
    }

    private void parse(String key, Object value) {
        if (value instanceof String) {
            String transUnit = (String)value;
            this.transUnits.put(key, transUnit);
        } else if (value instanceof LinkedHashMap) {
            LinkedHashMap map = (LinkedHashMap)value;
            for (String k : map.keySet()) {
                Object v = map.get(k);
                this.parse(String.valueOf(key) + "." + k, v);
            }
        }
    }

    public Map<String, String> getTranslations() {
        return this.transUnits;
    }
}

