/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.preferences;

import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.preferences.CorePreferencesSupport;
import org.eclipse.core.resources.IProject;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;

public class ProjectOptions {
    private ProjectOptions() {
    }

    public static final JSONArray getSyntheticServices(IProject project) {
        JSONArray defaultSynthetics = null;
        try {
            CorePreferencesSupport prefs = CorePreferencesSupport.getInstance();
            String synths = prefs.getPreferencesValue("synthetic_services", null, project);
            Logger.debugMSG("LOADED DEFAULTS: " + synths);
            JSONParser parser = new JSONParser();
            defaultSynthetics = (JSONArray)parser.parse(synths);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return defaultSynthetics;
    }

    public static final String getDefaultSyntheticServices() {
        return CorePreferencesSupport.getInstance().getWorkspacePreferencesValue("synthetic_services");
    }

    public static final boolean setSupportingTwig(boolean value, IProject project) {
        return CorePreferencesSupport.getInstance().setProjectSpecificPreferencesValue("twig_support", Boolean.toString(value), project);
    }
}

