/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.refactoring;

import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.model.Bundle;
import com.dubture.symfony.core.model.SymfonyModelAccess;
import com.dubture.symfony.index.SymfonyIndexer;
import com.dubture.symfony.index.handler.IServiceHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class RenameServiceClass
extends RenameParticipant {
    private IType type;

    protected boolean initialize(Object element) {
        if (element instanceof IType) {
            this.type = (IType)element;
            return true;
        }
        return false;
    }

    public String getName() {
        return "Rename Service Class";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        HashMap changes;
        block7: {
            ArrayList<IFolder> resources;
            block6: {
                if (this.type.getScriptProject() == null) {
                    return null;
                }
                resources = new ArrayList<IFolder>();
                SymfonyIndexer.getInstance().findServicesByClassName(PHPModelUtils.getFullName((IType)this.type), this.type.getScriptProject().getProject().getFullPath().toString(), new IServiceHandler(){

                    public void handle(String id, String phpClass, String path, String _public, String tags) {
                        try {
                            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
                            if (file.exists()) {
                                resources.add(file);
                            }
                        }
                        catch (Exception exception) {}
                    }
                });
                if (!resources.isEmpty()) break block6;
                return null;
            }
            try {
                resources.add(this.type.getScriptProject().getProject().getFolder("app/config"));
                List<Bundle> findBundles = SymfonyModelAccess.getDefault().findBundles(this.type.getScriptProject());
                for (Bundle bundle : findBundles) {
                    resources.add(ResourcesPlugin.getWorkspace().getRoot().getFolder(bundle.getPath().append("Resources").append("config")));
                }
                TextSearchScope searchScope = TextSearchScope.newSearchScope((IResource[])resources.toArray(new IResource[resources.size()]), (Pattern)Pattern.compile(".*"), (boolean)true);
                Pattern search = TextSearchEngine.createPattern((String)PHPModelUtils.getFullName((IType)this.type), (boolean)false, (boolean)false);
                final String newName = this.createNewName();
                changes = new HashMap();
                TextSearchRequestor collector = new TextSearchRequestor(){

                    public boolean acceptPatternMatch(TextSearchMatchAccess matchAccess) throws CoreException {
                        IFile file = matchAccess.getFile();
                        if (matchAccess.getMatchOffset() == 0) {
                            return true;
                        }
                        char fileContentChar = matchAccess.getFileContentChar(matchAccess.getMatchOffset() - 1);
                        if (!Character.isWhitespace(fileContentChar) && fileContentChar != '\'' && fileContentChar != '\"' && fileContentChar != ':' && fileContentChar != '>') {
                            return false;
                        }
                        int end = matchAccess.getMatchOffset() + matchAccess.getMatchLength();
                        if (end < matchAccess.getFileContentLength() && !Character.isWhitespace(fileContentChar = matchAccess.getFileContentChar(end)) && fileContentChar != '\'' && fileContentChar != '\"' && fileContentChar != '<') {
                            return false;
                        }
                        TextFileChange change = (TextFileChange)changes.get(file);
                        if (change == null) {
                            TextChange textChange = RenameServiceClass.this.getTextChange(file);
                            if (textChange != null) {
                                return false;
                            }
                            change = new TextFileChange(file.getName(), file);
                            change.setEdit((TextEdit)new MultiTextEdit());
                            changes.put(file, change);
                        }
                        ReplaceEdit edit = new ReplaceEdit(matchAccess.getMatchOffset(), matchAccess.getMatchLength(), newName);
                        change.addEdit((TextEdit)edit);
                        change.addTextEditGroup(new TextEditGroup("Update service reference", (TextEdit)edit));
                        return true;
                    }
                };
                TextSearchEngine.create().search(searchScope, collector, search, null);
                if (!changes.isEmpty()) break block7;
                return null;
            }
            catch (Exception e) {
                Logger.logException(e);
                return null;
            }
        }
        CompositeChange result = new CompositeChange("Rename service class");
        result.addAll(changes.values().toArray(new Change[changes.size()]));
        return result;
    }

    private String createNewName() throws ModelException {
        StringBuilder newName = new StringBuilder();
        if (this.type.getParent() instanceof IType) {
            newName.append(this.type.getParent().getElementName());
            newName.append("\\");
        }
        newName.append(this.getArguments().getNewName());
        return newName.toString();
    }
}

