/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.util;

import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.model.Bundle;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonUtils {
    private static JSONParser parser = new JSONParser();

    public static String createReference(String elementName, String qualifier, String viewPath, String method) {
        JSONObject data = new JSONObject();
        data.put((Object)"elementName", (Object)elementName);
        data.put((Object)"qualifier", (Object)qualifier);
        data.put((Object)"viewPath", (Object)viewPath);
        data.put((Object)"method", (Object)method);
        JSONObject header = new JSONObject();
        header.put((Object)"type", (Object)"reference");
        header.put((Object)"data", (Object)data);
        return header.toString();
    }

    public static String createDefaultSyntheticServices() {
        JSONArray data = new JSONArray();
        JSONObject request = new JSONObject();
        request.put((Object)"name", (Object)"request");
        request.put((Object)"class", (Object)"Symfony\\Component\\HttpFoundation\\Request");
        data.add((Object)request);
        return data.toString();
    }

    public static String getElementType(String metadata) {
        try {
            JSONObject json = (JSONObject)parser.parse(metadata);
            String type = (String)json.get((Object)"type");
            return type;
        }
        catch (ParseException e) {
            Logger.logException(e);
            return null;
        }
    }

    public static JSONObject getReferenceData(String metadata) {
        try {
            JSONObject header = (JSONObject)parser.parse(metadata);
            return (JSONObject)header.get((Object)"data");
        }
        catch (ParseException e) {
            Logger.logException(e);
            return null;
        }
    }

    public static JSONObject createService(String id, String className) {
        JSONObject service = new JSONObject();
        service.put((Object)"name", (Object)id);
        service.put((Object)"class", (Object)className);
        return service;
    }

    public static JSONArray parseArray(String defaults) {
        try {
            return (JSONArray)parser.parse(defaults);
        }
        catch (Exception e) {
            Logger.logException(e);
            return new JSONArray();
        }
    }

    public static JSONObject createBundle(ISourceModule sourceModule, ClassDeclaration classDec, NamespaceDeclaration namespace) {
        JSONObject bundle = new JSONObject();
        bundle.put((Object)"name", (Object)classDec.getName());
        bundle.put((Object)"namespace", (Object)(namespace != null ? namespace.getName() : ""));
        bundle.put((Object)"path", (Object)sourceModule.getPath().removeLastSegments(1).toString());
        return bundle;
    }

    public static Bundle unpackBundle(String metadata) {
        try {
            JSONObject json = (JSONObject)parser.parse(metadata);
            Bundle bundle = new Bundle(null, (String)json.get((Object)"name"));
            bundle.setPath((String)json.get((Object)"path"));
            return bundle;
        }
        catch (ParseException e) {
            Logger.logException(e);
            return null;
        }
    }

    public static String createScalar(String elementName, String viewPath, String method) {
        JSONObject data = new JSONObject();
        data.put((Object)"elementName", (Object)elementName);
        data.put((Object)"viewPath", (Object)viewPath);
        data.put((Object)"method", (Object)method);
        JSONObject header = new JSONObject();
        header.put((Object)"type", (Object)"scalar");
        header.put((Object)"data", (Object)data);
        return header.toString();
    }

    public static JSONObject getScalar(String metadata) {
        try {
            JSONObject header = (JSONObject)parser.parse(metadata);
            return (JSONObject)header.get((Object)"data");
        }
        catch (ParseException e) {
            Logger.logException(e);
            return null;
        }
    }
}

