/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.util;

import com.dubture.symfony.core.model.Bundle;
import com.dubture.symfony.core.model.Service;
import com.dubture.symfony.core.model.SymfonyModelAccess;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;

public class ModelUtils {
    public static Service extractServiceFromCall(PHPCallExpression call, IPath path) {
        Service service;
        Object first;
        List args;
        VariableReference ref;
        ASTNode receiver = call.getReceiver();
        if (receiver instanceof VariableReference && (ref = (VariableReference)receiver).getName().equals("$this") && (args = call.getArgs().getChilds()).size() == 1 && (first = args.get(0)) instanceof Scalar && ((Scalar)first).getScalarType() == 2 && (service = SymfonyModelAccess.getDefault().findService(((Scalar)first).getValue(), path)) != null) {
            return service;
        }
        return null;
    }

    public static String extractBundleName(NamespaceDeclaration namespace) {
        Assert.isNotNull((Object)namespace);
        return ModelUtils.extractBundleName(namespace.getName());
    }

    public static String extractBundleName(String fullyQualifiedName) {
        StringTokenizer tokenizer = new StringTokenizer(fullyQualifiedName, "\\");
        int i = 0;
        String prefix = "";
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (i++ == 0) {
                prefix = token;
            }
            if (token.equals("Bundle")) continue;
            if (token.endsWith("Bundle")) {
                return String.valueOf(prefix) + token;
            }
            if (i <= 1) continue;
            prefix = String.valueOf(prefix) + token;
        }
        return null;
    }

    public static String getControllerName(IType type) {
        if (!type.getElementName().endsWith("Controller")) {
            return type.getElementName();
        }
        return type.getElementName().replace("Controller", "");
    }

    public static String resolveControllerShortcut(String path, IScriptProject project) {
        Bundle b;
        String bundle;
        String[] parts;
        if (path.startsWith("@") && (parts = path.split("\\/")).length > 0 && (bundle = parts[0]).startsWith("@") && (b = SymfonyModelAccess.getDefault().findBundle(bundle.replace("@", ""), project)) != null) {
            return String.valueOf(b.getPath().toString()) + path.replace(bundle, "");
        }
        return null;
    }

    public static IPath webToBundlePath(IPath webpath, IScriptProject project) {
        IPath truncated;
        String bundleName;
        SymfonyModelAccess modelAccess = SymfonyModelAccess.getDefault();
        Bundle bundle = modelAccess.findBundle(bundleName = String.valueOf((truncated = webpath.removeFirstSegments(2)).segment(0)) + "bundle", project);
        if (bundle == null) {
            return null;
        }
        IPath bundlePath = bundle.getPath();
        IPath resourcePath = bundlePath.append("Resources").append("public").append(truncated.removeFirstSegments(1));
        return resourcePath.removeFirstSegments(1);
    }
}

