/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.util;

import com.dubture.symfony.core.model.SymfonyModelAccess;
import com.dubture.symfony.core.util.ModelUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class PathUtils {
    public static String getControllerFromTemplatePath(IPath path) {
        int size = path.segmentCount();
        int i = 0;
        while (i < size) {
            if (path.segment(i).equals("views") && i + 1 < size) {
                return String.valueOf(path.segment(i + 1)) + "Controller";
            }
            ++i;
        }
        return null;
    }

    public static String getViewFromTemplatePath(IPath path) {
        String fileName = path.lastSegment();
        if (fileName.indexOf(".") > -1) {
            return fileName.substring(0, fileName.indexOf(46));
        }
        return null;
    }

    public static boolean isTemplateVariable(IField field, ISourceModule module) {
        IMethod[] methods;
        ISourceModule fieldModule = field.getSourceModule();
        IPath fieldPath = fieldModule.getPath();
        String controller = PathUtils.getControllerFromFieldPath(fieldPath);
        String viewName = PathUtils.getViewFromTemplatePath(module.getPath());
        if (controller == null || viewName == null) {
            return false;
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)field.getSourceModule());
        IMethod[] iMethodArray = methods = PHPModelAccess.getDefault().findMethods(null, ISearchEngine.MatchRule.PREFIX, 0, 0, scope, null);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getElementName().startsWith(viewName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getControllerFromFieldPath(IPath path) {
        if (path.segment(path.segmentCount() - 2).equals("Controller") && path.getFileExtension().equals("php")) {
            return path.lastSegment().replace(".php", "");
        }
        return null;
    }

    public static boolean isViewPath(String path) {
        return StringUtils.occurrencesOf((String)path, (char)':') == 2;
    }

    public static String createViewPathFromTemplate(ISourceModule sourceModule, boolean keepFileExtension) {
        IType controller;
        SymfonyModelAccess model = SymfonyModelAccess.getDefault();
        String viewName = sourceModule.getPath().lastSegment();
        if (!keepFileExtension) {
            viewName = PathUtils.getViewFromTemplatePath(sourceModule.getPath());
        }
        if ((controller = model.findControllerByTemplate(sourceModule)) == null) {
            return null;
        }
        String bundle = ModelUtils.extractBundleName(controller.getFullyQualifiedName());
        if (bundle == null) {
            return null;
        }
        String controllerPart = controller.getElementName().replace("Controller", "");
        return String.format("%s:%s:%s", bundle, controllerPart, viewName);
    }

    public static String createViewPath(Scalar view) {
        return PathUtils.createViewPath(view.getValue());
    }

    public static String createViewPath(String viewString) {
        String path = viewString.replaceAll("['\"]", "");
        int dotIndex = path.indexOf(46);
        if (dotIndex == -1) {
            return path;
        }
        return path.substring(0, dotIndex);
    }
}

