/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.util;

import com.dubture.symfony.core.model.Resource;
import com.dubture.symfony.core.model.SymfonyModelAccess;
import com.dubture.symfony.core.model.SymfonyResourceAccess;
import com.dubture.symfony.core.util.ModelUtils;
import com.dubture.symfony.index.model.Route;
import com.dubture.symfony.index.model.RouteParameter;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;

public class RoutingUtil {
    public static String getURL(String base, Route route, IScriptProject project) {
        String URL2 = null;
        List<Resource> resources = SymfonyResourceAccess.getDefault().getResources(project);
        IType controller = SymfonyModelAccess.getDefault().findController(route.bundle, route.controller, project);
        String prefix = null;
        if (controller != null) {
            for (Resource resource : resources) {
                String controllerp;
                if (resource.type != Resource.ROUTE_RESOURCE || (controllerp = ModelUtils.resolveControllerShortcut(resource.path, project)) == null || !controllerp.equals(controller.getPath().toString())) continue;
                prefix = resource.prefix;
                break;
            }
        }
        if (route.hasParameters()) {
            Map parameters = route.getParameters();
            for (String name : parameters.keySet()) {
                RouteParameter param = (RouteParameter)parameters.get(name);
                param.setValue(param.getName());
            }
            URL2 = String.valueOf(base) + route.getURL(parameters.values(), prefix);
        } else {
            URL2 = String.valueOf(base) + route.getURL(prefix);
        }
        return URL2;
    }
}

