/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.compress.utils.IOUtils;

public final class UncompressUtils {
    private static final int BUFFER_SIZE = 8192;
    private static final EntryNameTranslator IDENTITY_TRANSLATOR = new EntryNameTranslator(){

        @Override
        public String translate(String entryName) {
            return entryName;
        }
    };

    private UncompressUtils() {
    }

    public static File uncompressGzipArchive(File archiveFile, File outputDirectory) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(archiveFile);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        GzipCompressorInputStream gzipInputStream = new GzipCompressorInputStream((InputStream)bufferedInputStream);
        String tarArchiveFilename = GzipUtils.getUncompressedFilename((String)archiveFile.getName());
        File outputFile = new File(outputDirectory, tarArchiveFilename);
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        int byteReadCount = 0;
        byte[] data = new byte[8192];
        try {
            while ((byteReadCount = gzipInputStream.read(data, 0, 8192)) != -1) {
                outputStream.write(data, 0, byteReadCount);
            }
        }
        finally {
            outputStream.close();
            gzipInputStream.close();
        }
        return outputFile;
    }

    public static void uncompressTarArchive(File archiveFile, File outputDirectory) throws IOException {
        UncompressUtils.uncompressTarArchive(archiveFile, outputDirectory, IDENTITY_TRANSLATOR);
    }

    public static void uncompressTarArchive(File archiveFile, File outputDirectory, EntryNameTranslator entryNameTranslator) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(archiveFile);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        try (TarArchiveInputStream tarInputStream = new TarArchiveInputStream((InputStream)bufferedInputStream);){
            TarArchiveEntry tarEntry = null;
            while ((tarEntry = tarInputStream.getNextTarEntry()) != null) {
                UncompressUtils.uncompressTarArchiveEntry(tarInputStream, tarEntry, outputDirectory, entryNameTranslator);
            }
        }
    }

    public static void uncompressTarArchiveEntry(TarArchiveInputStream tarInputStream, TarArchiveEntry entry, File outputDirectory) throws IOException {
        UncompressUtils.uncompressTarArchiveEntry(tarInputStream, entry, outputDirectory, IDENTITY_TRANSLATOR);
    }

    public static void uncompressTarArchiveEntry(TarArchiveInputStream tarInputStream, TarArchiveEntry entry, File outputDirectory, EntryNameTranslator entryNameTranslator) throws IOException {
        String entryName = entryNameTranslator.translate(entry.getName());
        if (entry.isDirectory()) {
            UncompressUtils.createDirectory(new File(outputDirectory, entryName));
            return;
        }
        File outputFile = new File(outputDirectory, entryName);
        UncompressUtils.ensureDirectoryHierarchyExists(outputFile);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));){
            IOUtils.copy((InputStream)tarInputStream, (OutputStream)outputStream);
            UncompressUtils.addExecutableBit(outputFile, Permissions.fromMode(entry.getMode()));
        }
    }

    private static boolean addExecutableBit(File file, Permissions permissions) {
        if (file.isDirectory() || !permissions.hasExecutableBit()) {
            return false;
        }
        return file.setExecutable(true, permissions.hasOnlyOwnerExecutableBit());
    }

    private static void createDirectory(File directory) {
        if (directory.exists()) {
            return;
        }
        if (!directory.mkdirs()) {
            throw new RuntimeException("Cannot create directory " + directory);
        }
    }

    private static void ensureDirectoryHierarchyExists(File outputFile) {
        if (!outputFile.getParentFile().exists()) {
            UncompressUtils.createDirectory(outputFile.getParentFile());
        }
    }

    public static interface EntryNameTranslator {
        public String translate(String var1);
    }

    protected static class Permissions {
        private static final int PACK_MASK = 7;
        private static final int EXECUTABLE_MASK = 1;
        int mode;
        boolean hasExecutableBitOwner;
        boolean hasExecutableBitGroup;
        boolean hasExecutableBitOther;

        public static Permissions fromMode(int mode) {
            return new Permissions(mode);
        }

        public static Permissions fromUnixMode(String mode) {
            return new Permissions(Integer.parseInt(mode, 8));
        }

        private Permissions(int mode) {
            this.mode = mode;
            this.setOwner(this.getBitsPack(0));
            this.setGroup(this.getBitsPack(1));
            this.setOther(this.getBitsPack(2));
        }

        public boolean hasExecutableBit() {
            return this.hasExecutableBitOwner || this.hasExecutableBitGroup || this.hasExecutableBitOther;
        }

        public boolean hasOnlyOwnerExecutableBit() {
            return this.hasExecutableBitOwner && !this.hasExecutableBitGroup && !this.hasExecutableBitOther;
        }

        private void setOwner(int ownerPack) {
            this.hasExecutableBitOwner = (ownerPack & 1) == 1;
        }

        private void setGroup(int groupPack) {
            this.hasExecutableBitGroup = (groupPack & 1) == 1;
        }

        private void setOther(int otherPack) {
            this.hasExecutableBitOther = (otherPack & 1) == 1;
        }

        private int getBitsPack(int packId) {
            assert (packId > 0 && packId <= 2);
            int offset = packId * 3;
            return this.mode >> offset & 7;
        }

        public String toString() {
            String owner = "Owner: " + (this.hasExecutableBitOwner ? "x" : "-");
            String group = "Group: " + (this.hasExecutableBitGroup ? "x" : "-");
            String other = "Other: " + (this.hasExecutableBitOther ? "x" : "-");
            return String.valueOf(owner) + ", " + group + ", " + other;
        }
    }
}

