/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.util.text;

import com.dubture.symfony.core.model.SymfonyModelAccess;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.internal.core.util.text.TextSequence;

public class SymfonyTextSequenceUtilities {
    private static final Pattern SERVICE_PATTERN = Pattern.compile("(\\$this->get\\(|\\$this->container->get\\(|->getContainer\\(\\)->get\\()");
    private static final Pattern GET_PATTERN = Pattern.compile("(->get\\()");
    private static final Pattern REPOSITORY_PATTERN = Pattern.compile("\\->getRepository\\(");
    private static final Pattern TRANSLATION_PATTERN = Pattern.compile("(\\->transChoice\\(|\\->trans\\()");

    private SymfonyTextSequenceUtilities() {
    }

    public static int readViewPathStartIndex(CharSequence textSequence) {
        int startPosition = textSequence.length() - 1;
        return SymfonyTextSequenceUtilities.readLiteralStartIndex(textSequence, startPosition);
    }

    public static int isInServiceContainerFunction(CharSequence sequence) {
        Matcher matcher = SERVICE_PATTERN.matcher(sequence);
        if (matcher.find()) {
            int pos = matcher.end();
            int lastMethodCall = sequence.toString().lastIndexOf("(");
            if (lastMethodCall > pos) {
                return -1;
            }
            return pos;
        }
        return -1;
    }

    public static int isGetFunction(CharSequence sequence) {
        Matcher matcher = GET_PATTERN.matcher(sequence);
        if (matcher.find()) {
            int pos = matcher.end();
            int lastMethodCall = sequence.toString().lastIndexOf("(");
            if (lastMethodCall > pos) {
                return -1;
            }
            return pos;
        }
        return -1;
    }

    public static int isInEntityFunctionParameter(CharSequence sequence) {
        Matcher matcher = REPOSITORY_PATTERN.matcher(sequence);
        if (matcher.find()) {
            int pos = matcher.end();
            int lastMethodCall = sequence.toString().lastIndexOf("(");
            if (lastMethodCall > pos) {
                return -1;
            }
            return pos;
        }
        return -1;
    }

    public static int isInTranslationFunctionParameter(CharSequence sequence) {
        Matcher matcher = TRANSLATION_PATTERN.matcher(sequence);
        if (matcher.find()) {
            int pos = matcher.end();
            int lastMethodCall = sequence.toString().lastIndexOf("(");
            if (lastMethodCall > pos) {
                return -1;
            }
            return pos;
        }
        return -1;
    }

    public static String removeQuotes(String source) {
        return source.replaceAll("['\"]", "");
    }

    public static String getServiceFromMethodParam(TextSequence sequence) {
        String source = sequence.toString();
        int start = source.indexOf("(") + 1;
        int end = source.indexOf(")") - 1;
        if (start < 0 || end < 0 || end < start) {
            return null;
        }
        return SymfonyTextSequenceUtilities.removeQuotes(source.substring(start, end));
    }

    public static String getMethodName(CharSequence statement) {
        int end;
        String text = statement.toString();
        int start = text.indexOf("->");
        int current = end = text.lastIndexOf("(");
        while (current > 0 && current > start) {
            char c;
            if ((c = text.charAt(current--)) != '>') continue;
            return text.substring(current + 2, end);
        }
        return null;
    }

    public static boolean isInViewPathFunctionParameter(TextSequence statement, IScriptProject project) {
        String method = SymfonyTextSequenceUtilities.getMethodName((CharSequence)statement);
        if (method == null) {
            return false;
        }
        return SymfonyModelAccess.getDefault().hasViewMethod(method, project);
    }

    public static boolean isInRouteFunctionParameter(TextSequence statement, IScriptProject project) {
        String method = SymfonyTextSequenceUtilities.getMethodName((CharSequence)statement);
        if (method == null) {
            return false;
        }
        return SymfonyModelAccess.getDefault().hasRouteMethod(method, project);
    }

    public static int readLiteralStartIndex(CharSequence textSequence, int startPosition) {
        while (startPosition > 0) {
            char ch = textSequence.charAt(startPosition - 1);
            if (!Character.isLetterOrDigit(ch) && ch != ':' && ch != '.' && ch != '_' && ch != '/') break;
            --startPosition;
        }
        if (startPosition > 0 && startPosition < textSequence.length() && (textSequence.charAt(startPosition) == '\"' || textSequence.charAt(startPosition) == '\'')) {
            ++startPosition;
        }
        return startPosition;
    }

    public static int readLiteralEndIndex(CharSequence textSequence, int startPosition) {
        int max = textSequence.length() - 1;
        while (startPosition < max) {
            char ch = textSequence.charAt(startPosition);
            if (!Character.isLetterOrDigit(ch) && ch != ':' && ch != '.' && ch != '_') break;
            ++startPosition;
        }
        if (startPosition > 0 && (textSequence.charAt(startPosition - 1) == '\"' || textSequence.charAt(startPosition - 1) == '\'')) {
            --startPosition;
        }
        return startPosition;
    }
}

