/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.validation;

import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.parser.XMLConfigParser;
import com.dubture.symfony.index.model.Service;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;

public class ServiceDefinitionValidator
extends AbstractValidator {
    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1 || resource.isDerived(512)) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IFile file = (IFile)resource;
        if (!"xml".equals(file.getFileExtension())) {
            return null;
        }
        IScriptProject scriptProject = DLTKCore.create((IProject)resource.getProject());
        try {
            XMLConfigParser parser = new XMLConfigParser(file.getContents());
            parser.parse();
            HashMap<String, Service> services = parser.getServices();
            Iterator<String> it = services.keySet().iterator();
            PHPModelAccess model = PHPModelAccess.getDefault();
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            while (it.hasNext()) {
                String key = it.next();
                Service service = services.get(key);
                if (service == null) {
                    Logger.log(1, "Error setting marker for service " + key);
                    continue;
                }
                String phpClass = service.getPHPClass();
                if ("synthetic".equals(phpClass)) {
                    Logger.log(1, "Error setting marker for synthetic service " + key);
                    continue;
                }
                IType[] types = model.findTypes(phpClass, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
                if (types.length != 0) continue;
                IMarker marker = resource.createMarker("com.dubture.symfony.core.serviceMarker");
                marker.setAttribute("serviceClass", (Object)phpClass);
                marker.setAttribute("resolutionText", (Object)("Create class " + phpClass));
                marker.setAttribute("severity", 1);
                marker.setAttribute("problemType", (Object)"com.dubture.symfony.core.serviceMarker");
                marker.setAttribute("message", (Object)("Class " + phpClass + " does not exist"));
                marker.setAttribute("lineNumber", (Object)service.getLine());
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return result;
    }
}

