/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.debug.launch;

import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.model.AppKernel;
import com.dubture.symfony.core.model.SymfonyKernelAccess;
import com.dubture.symfony.debug.launch.SymfonyURLLaunchDialog;
import com.dubture.symfony.debug.util.ServerUtils;
import com.dubture.symfony.index.model.Route;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.util.FileUtils;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.ui.launching.Messages;
import org.eclipse.php.internal.server.ui.launching.PHPWebPageLaunchDialog;
import org.eclipse.php.internal.server.ui.launching.PHPWebPageLaunchShortcut;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class LaunchActionShortcut
extends PHPWebPageLaunchShortcut {
    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType configType = lm.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.webPageLaunch");
            LaunchActionShortcut.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode, configType);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        if (file != null) {
            ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType configType = lm.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.webPageLaunch");
            LaunchActionShortcut.searchAndLaunch(new Object[]{file}, mode, configType);
        }
    }

    static ILaunchConfiguration findLaunchConfiguration(IProject project, String fileName, String selectedURL, Server server, String mode, ILaunchConfigurationType configType, boolean breakAtFirstLine, boolean showDebugDialog, IResource res, Route route, IScriptProject scriptProject) {
        ILaunchConfiguration config = null;
        Logger.debugMSG((String)"trying to find launc configuration");
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            int numConfigs = configs == null ? 0 : configs.length;
            int i = 0;
            while (i < numConfigs) {
                String configuredRouteName = configs[i].getAttribute("route", null);
                if (configuredRouteName != null && configuredRouteName.equals(route.getName())) {
                    config = configs[i].getWorkingCopy();
                    Logger.debugMSG((String)("found existing: " + configuredRouteName));
                    break;
                }
                ++i;
            }
            if (config == null) {
                Logger.debugMSG((String)"no launch config found; create new one");
                config = LaunchActionShortcut.createConfiguration(project, fileName, selectedURL, server, configType, mode, breakAtFirstLine, showDebugDialog, res, route, scriptProject);
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return config;
    }

    public static void searchAndLaunch(Object[] search, String mode, ILaunchConfigurationType configType) {
        int entries = search == null ? 0 : search.length;
        new Route("foo", "bar");
        int i = 0;
        while (i < entries) {
            block16: {
                try {
                    Server defaultServer;
                    String phpPathString = null;
                    IProject project = null;
                    Object obj = search[i];
                    IFile res = null;
                    if (obj instanceof IModelElement) {
                        IModelElement elem = (IModelElement)obj;
                        if (elem instanceof ISourceModule) {
                            res = ((ISourceModule)elem).getCorrespondingResource();
                        } else if (elem instanceof IType) {
                            res = ((IType)elem).getUnderlyingResource();
                        } else if (elem instanceof IMethod) {
                            res = ((IMethod)elem).getUnderlyingResource();
                        }
                        if (res instanceof IFile) {
                            obj = res;
                        }
                    }
                    if (obj instanceof IFile) {
                        IFile file;
                        res = file = (IFile)obj;
                        project = file.getProject();
                        IContentType contentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
                        if (contentType.isAssociatedWith(file.getName())) {
                            phpPathString = file.getFullPath().toString();
                        }
                    }
                    if ((defaultServer = ServersManager.getDefaultServer(project)) == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, Messages.PHPWebPageLaunchShortcut_0, null));
                    }
                    PHPProjectPreferences.getDefaultBasePath(project);
                    PHPProjectPreferences.getStopAtFirstLine((IProject)project);
                    if (obj instanceof IScriptProject) {
                        PHPWebPageLaunchDialog dialog = new PHPWebPageLaunchDialog(mode, (IScriptProject)obj);
                        int open = dialog.open();
                        if (open != 0) break block16;
                        defaultServer = dialog.getServer();
                        dialog.getPHPPathString();
                        phpPathString = dialog.getFilename();
                        dialog.isBreakAtFirstLine();
                    }
                    if (phpPathString == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, Messages.launch_failure_no_target, null));
                    }
                }
                catch (CoreException ce) {
                    final IStatus stat = ce.getStatus();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ErrorDialog.openError((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)Messages.launch_failure_msg_title, (String)Messages.launch_failure_server_msg_text, (IStatus)stat);
                        }
                    });
                }
            }
            ++i;
        }
    }

    static ILaunchConfiguration createConfiguration(IProject project, String fileName, String selectedURL, Server server, ILaunchConfigurationType configType, String mode, boolean breakAtFirstLine, boolean showDebugDialog, IResource res, Route route, IScriptProject scriptProject) throws CoreException {
        AppKernel kernel;
        String URL2;
        ILaunchConfigurationWorkingCopy wc;
        ILaunchConfiguration config;
        block10: {
            config = null;
            if (!FileUtils.resourceExists((String)fileName)) {
                Logger.debugMSG((String)("file not existing: " + fileName));
                return null;
            }
            wc = configType.newInstance(null, LaunchActionShortcut.getNewConfigurationName(route));
            String debuggerID = PHPProjectPreferences.getDefaultDebuggerID((IProject)project);
            wc.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, debuggerID);
            AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration((String)debuggerID);
            wc.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, debuggerConfiguration.getWebLaunchDelegateClass());
            wc.setAttribute("name", server.getName());
            wc.setAttribute("file_name", fileName);
            wc.setAttribute("base_url", "");
            wc.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", PHPDebugPlugin.getDebugInfoOption());
            wc.setAttribute("org.eclipse.php.debug.core.OpenInBrowser", PHPDebugPlugin.getOpenInBrowserOption());
            wc.setAttribute("firstLineBreakpoint", breakAtFirstLine);
            if (res != null) {
                wc.setMappedResources(new IResource[]{res});
            }
            config = wc.doSave();
            URL2 = null;
            Logger.debugMSG((String)("getting dev kernel from " + scriptProject.getElementName()));
            kernel = SymfonyKernelAccess.getDefault().getDevelopmentKernel(scriptProject);
            if (kernel == null) {
                Logger.debugMSG((String)"No kernel found");
                return null;
            }
            Logger.debugMSG((String)("kernel found: " + kernel.getScript()));
            if (selectedURL != null) {
                Logger.debugMSG((String)("found exisiting url: " + selectedURL));
                URL2 = selectedURL;
            } else {
                try {
                    URL2 = ServerUtils.constructURL(config, scriptProject, route, kernel);
                    Logger.debugMSG((String)("Generated launch configuration url: " + URL2));
                    if (URL2 == null) {
                        URL2 = "";
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (URL2 != null) break block10;
                    URL2 = "";
                }
            }
        }
        wc.setAttribute("base_url", URL2);
        wc.setAttribute("symfony_url", URL2);
        if (route.hasParameters()) {
            String title = "Please insert the required route parameters";
            SymfonyURLLaunchDialog launchDialog = new SymfonyURLLaunchDialog(wc, title, route);
            launchDialog.setBlockOnOpen(true);
            if (launchDialog.open() != 0) {
                LaunchActionShortcut.deleteLaunchconfig(config);
                return null;
            }
        }
        wc.setAttribute("route", route.getName());
        wc.setAttribute("environment", kernel.getEnvironment());
        config = wc.doSave();
        return config;
    }

    private static void deleteLaunchconfig(final ILaunchConfiguration launchConfig) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ILaunchConfiguration config = launchConfig;
                try {
                    if (config instanceof ILaunchConfigurationWorkingCopy) {
                        config = ((ILaunchConfigurationWorkingCopy)config).getOriginal();
                    }
                    if (config != null) {
                        config.delete();
                    }
                }
                catch (CoreException coreException) {}
            }
        });
    }

    protected static String getNewConfigurationName(Route route) {
        String configurationName = Messages.PHPWebPageLaunchShortcut_4;
        try {
            configurationName = route.getName();
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        return DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(configurationName);
    }
}

