/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.debug.launch;

import com.dubture.symfony.core.builder.SymfonyNature;
import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.model.AppKernel;
import com.dubture.symfony.core.model.SymfonyKernelAccess;
import com.dubture.symfony.core.model.SymfonyModelAccess;
import com.dubture.symfony.debug.util.ServerUtils;
import com.dubture.symfony.index.model.Route;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private Combo kernelCombo;
    private Text route;
    private Route currentRoute;
    private AutoCompleteField ac;
    private SymfonyModelAccess model = SymfonyModelAccess.getDefault();
    private IScriptProject project;
    private List<AppKernel> kernels;
    private AppKernel kernel;
    private boolean isSymfonyDebugger = false;
    private Composite comp;
    private ILaunchConfiguration config;
    private KeyListener routeListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            if (LaunchConfigurationTab.this.project == null) {
                return;
            }
            String prefix = LaunchConfigurationTab.this.route.getText();
            if (prefix.length() < 1) {
                return;
            }
            List routes = LaunchConfigurationTab.this.model.findRoutes(LaunchConfigurationTab.this.project, prefix);
            String[] names = new String[routes.size()];
            int i = 0;
            for (Route route : routes) {
                names[i++] = route.getName();
            }
            LaunchConfigurationTab.this.ac.setProposals(names);
        }

        public void keyPressed(KeyEvent e) {
        }
    };
    private Text url;

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        try {
            if (this.project == null || !this.project.getProject().hasNature(SymfonyNature.NATURE_ID)) {
                return true;
            }
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
            return true;
        }
        if (!this.isSymfonyDebugger) {
            return true;
        }
        String routeName = this.route.getText();
        Route route = this.model.findRoute(routeName, this.project);
        if (route == null) {
            String message = "The route " + routeName + " does not exist in the project " + this.project.getElementName();
            if (routeName.length() == 0) {
                message = "You need to set a valid route name for the launch configuration";
            }
            this.setErrorMessage(message);
            return false;
        }
        try {
            new URL(this.url.getText());
        }
        catch (MalformedURLException malformedURLException) {
            this.setMessage("Malformed URL : " + this.url.getText());
            return false;
        }
        return true;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        this.comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.comp.setLayout((Layout)layout);
        this.comp.setFont(font);
        GridData gd = new GridData(1808);
        this.comp.setLayoutData((Object)gd);
        this.setControl((Control)this.comp);
        Group group = new Group(this.comp, 0);
        group.setFont(font);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        String controlName = "Launch Settings";
        group.setText(controlName);
        Label label = new Label((Composite)group, 0);
        label.setText("Environment");
        GridData data = new GridData(200, 4, true, false);
        label.setLayoutData((Object)data);
        this.kernelCombo = new Combo((Composite)group, 8);
        data = new GridData();
        data.horizontalIndent = 0;
        this.kernelCombo.setLayoutData((Object)data);
        this.kernelCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (AppKernel k : LaunchConfigurationTab.this.kernels) {
                    String env = LaunchConfigurationTab.this.kernelCombo.getItem(LaunchConfigurationTab.this.kernelCombo.getSelectionIndex());
                    if (!env.equals(k.getEnvironment())) continue;
                    LaunchConfigurationTab.this.kernel = k;
                    break;
                }
                LaunchConfigurationTab.this.setDirty(true);
                LaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                LaunchConfigurationTab.this.updateURL();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label routeLabel = new Label((Composite)group, 0);
        routeLabel.setText("Route");
        this.route = new Text((Composite)group, 2052);
        data = new GridData();
        data.widthHint = 200;
        this.route.addKeyListener(this.routeListener);
        this.route.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                LaunchConfigurationTab.this.currentRoute = LaunchConfigurationTab.this.model.findRoute(LaunchConfigurationTab.this.route.getText(), LaunchConfigurationTab.this.project);
                LaunchConfigurationTab.this.setDirty(true);
                LaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                LaunchConfigurationTab.this.updateURL();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.route.setLayoutData((Object)data);
        this.ac = new AutoCompleteField((Control)this.route, (IControlContentAdapter)new TextContentAdapter(), new String[0]);
        Label urlLabel = new Label((Composite)group, 0);
        urlLabel.setText("Generated URL");
        this.url = new Text((Composite)group, 2052);
        this.url.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                LaunchConfigurationTab.this.setDirty(true);
                LaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        data = new GridData(4, 2, true, false);
        this.url.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)this.comp);
        this.setControl((Control)this.comp);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        try {
            String env = configuration.getAttribute("environment", "");
            if (env.length() == 0) {
                return;
            }
            int i = 0;
            while (i < this.kernelCombo.getItemCount()) {
                String item = this.kernelCombo.getItem(i);
                if (item.equals(env)) {
                    this.kernelCombo.select(i);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.config = configuration;
        this.initializeProject(configuration);
        if (this.project == null) {
            return;
        }
        this.initializeEnvironment(configuration);
        this.initializeRoute(configuration);
        this.initializeURL(configuration);
        this.isValid(configuration);
    }

    private void initializeURL(ILaunchConfiguration configuration) {
        try {
            String _url = configuration.getAttribute("symfony_url", "");
            if (_url.length() == 0) {
                this.updateURL();
            } else {
                this.url.setText(_url);
            }
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
    }

    private void updateURL() {
        try {
            if (this.currentRoute == null) {
                this.url.setText("");
                return;
            }
            String _url = ServerUtils.constructURL(this.config, this.project, this.currentRoute, this.kernel);
            this.url.setText(_url);
            this.config.getWorkingCopy().setAttribute("base_url", _url);
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
    }

    private void initializeProject(ILaunchConfiguration configuration) {
        this.comp.setEnabled(false);
        try {
            IProject rawProject;
            String debuggerID = configuration.getAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, "");
            this.isSymfonyDebugger = "com.dubture.symfony.debug.xdebugger".equals(debuggerID);
            if (!this.isSymfonyDebugger) {
                return;
            }
            String file = configuration.getAttribute("file_name", "");
            Path path = new Path(file);
            this.kernels = new ArrayList<AppKernel>();
            if (path != null && path.segmentCount() > 0 && (rawProject = ResourcesPlugin.getWorkspace().getRoot().getProject(path.removeLastSegments(path.segmentCount() - 1).toString())) != null) {
                this.project = DLTKCore.create((IProject)rawProject);
                this.kernels = SymfonyKernelAccess.getDefault().getKernels(this.project);
            }
            if (this.project != null && this.project.getProject().hasNature(SymfonyNature.NATURE_ID)) {
                this.comp.setEnabled(true);
            }
        }
        catch (CoreException coreException) {}
    }

    private void initializeEnvironment(ILaunchConfiguration configuration) {
        try {
            this.kernelCombo.removeAll();
            if (this.project == null) {
                this.comp.setEnabled(false);
                return;
            }
            String env = configuration.getAttribute("environment", "");
            this.comp.setEnabled(true);
            int i = 0;
            for (AppKernel kernel : this.kernels) {
                this.kernelCombo.add(kernel.getEnvironment());
                if (kernel.getEnvironment().equals(env)) {
                    this.kernelCombo.select(i);
                    this.kernel = kernel;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    private void initializeRoute(ILaunchConfiguration configuration) {
        try {
            String name = configuration.getAttribute("route", "");
            this.currentRoute = this.model.findRoute(name, this.project);
            this.route.setText(name);
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        try {
            if (!this.isSymfonyDebugger) {
                return;
            }
            int index = this.kernelCombo.getSelectionIndex();
            if (this.kernelCombo.getItemCount() > 0 && index >= 0 && index < this.kernelCombo.getItemCount()) {
                String env = this.kernelCombo.getItem(this.kernelCombo.getSelectionIndex());
                configuration.setAttribute("environment", env);
            }
            configuration.setAttribute("base_url", this.url.getText());
            configuration.setAttribute("symfony_url", this.url.getText());
            String routeName = this.route.getText();
            configuration.setAttribute("route", routeName);
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
    }

    public String getName() {
        return "Symfony";
    }
}

