/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.debug.util;

import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.model.AppKernel;
import com.dubture.symfony.core.util.RoutingUtil;
import com.dubture.symfony.index.model.Route;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;

public class ServerUtils {
    public static String getBaseUrl(ILaunchConfiguration configuration, IScriptProject project, AppKernel kernel) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
        Server server = ServersManager.getServer((String)configuration.getAttribute("name", ""));
        if (kernel == null) {
            return null;
        }
        String env = kernel.getEnvironment();
        wc.setAttribute("environment", env);
        wc.doSave();
        boolean isVhost = ServerUtils.isVirtualHost(server, kernel);
        String base = "";
        base = isVhost ? String.format("%s/%s", server.getBaseURL(), kernel.getScript()) : String.format("%s/%s/%s", server.getBaseURL(), project.getElementName(), kernel.getPath());
        return base;
    }

    public static boolean isVirtualHost(Server server, AppKernel kernel) {
        return server.getDocumentRoot().endsWith(kernel.getRawPath().removeLastSegments(1).toString());
    }

    public static void injectRoutingURL(ILaunchConfiguration configuration, AppKernel kernel, IScriptProject project, Route route) {
        try {
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            String url = ServerUtils.constructURL(configuration, project, route, kernel);
            if (url != null) {
                wc.setAttribute("base_url", url);
                wc.doSave();
            }
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
    }

    public static String constructURL(ILaunchConfiguration configuration, IScriptProject project, Route route, AppKernel kernel) {
        String base = null;
        try {
            base = ServerUtils.getBaseUrl(configuration, project, kernel);
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
        if (base == null) {
            return null;
        }
        return RoutingUtil.getURL((String)base, (Route)route, (IScriptProject)project);
    }
}

