/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.index;

import com.dubture.symfony.index.SymfonyIndex;
import com.dubture.symfony.index.log.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class Schema {
    public static final String VERSION = "0.11";

    public void initialize(Connection connection) throws SQLException {
        try {
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate(Schema.readSqlFile("Resources/index/basic.sql"));
                statement.executeUpdate(Schema.readSqlFile("Resources/index/routes/basic.sql"));
                statement.executeUpdate(Schema.readSqlFile("Resources/index/parameters/basic.sql"));
                statement.executeUpdate(Schema.readSqlFile("Resources/index/translations/basic.sql"));
                statement.executeUpdate(Schema.readSqlFile("Resources/index/resources/basic.sql"));
            }
            this.storeSchemaVersion(VERSION);
        }
        catch (SQLException e) {
            Logger.logException(e);
            throw e;
        }
    }

    public boolean isCompatible() {
        String storedVersion = this.getStoredSchemaVersion();
        return storedVersion != null && VERSION.equals(storedVersion);
    }

    private String getStoredSchemaVersion() {
        return Platform.getPreferencesService().getString("com.dubture.symfony.index", "0.2", null, null);
    }

    private void storeSchemaVersion(String newVersion) {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("com.dubture.symfony.index");
        node.put("0.2", newVersion);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static String readSqlFile(String sqlFile) {
        try {
            URL url = FileLocator.find((Bundle)SymfonyIndex.getDefault().getBundle(), (IPath)new Path(sqlFile), null);
            URL resolved = FileLocator.resolve((URL)url);
            StringBuilder buf = new StringBuilder();
            try (BufferedReader r = new BufferedReader(new InputStreamReader(resolved.openStream()));){
                String line;
                while ((line = r.readLine()) != null) {
                    buf.append(line).append('\n');
                }
            }
            return buf.toString();
        }
        catch (IOException e) {
            Logger.logException(e);
            return null;
        }
    }
}

