/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.index;

import com.dubture.symfony.index.IShutdownListener;
import com.dubture.symfony.index.Schema;
import com.dubture.symfony.index.SymfonyIndex;
import com.dubture.symfony.index.dao.IParameterDao;
import com.dubture.symfony.index.dao.IResourceDao;
import com.dubture.symfony.index.dao.IRouteDao;
import com.dubture.symfony.index.dao.IServiceDao;
import com.dubture.symfony.index.dao.ITransUnitDao;
import com.dubture.symfony.index.dao.sql.ParameterDao;
import com.dubture.symfony.index.dao.sql.ResourceDao;
import com.dubture.symfony.index.dao.sql.RouteDao;
import com.dubture.symfony.index.dao.sql.ServiceDao;
import com.dubture.symfony.index.dao.sql.TransUnitDao;
import com.dubture.symfony.index.log.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.h2.jdbcx.JdbcConnectionPool;
import org.h2.tools.DeleteDbFiles;

public class SymfonyDbFactory {
    private static ILock instanceLock = Job.getJobManager().newLock();
    private static final String DB_NAME = "symfonymodel";
    private static final String DB_USER = "";
    private static final String DB_PASS = "";
    private JdbcConnectionPool pool;
    private static SymfonyDbFactory instance = null;
    private ServiceDao serviceDao = new ServiceDao();
    private ParameterDao parameterDao = new ParameterDao();
    private RouteDao routeDao = new RouteDao();
    private ResourceDao resourceDao = new ResourceDao();
    private TransUnitDao transUnitDao = new TransUnitDao();

    public static SymfonyDbFactory getInstance() {
        if (instance == null) {
            try {
                try {
                    instanceLock.acquire();
                    instance = new SymfonyDbFactory();
                    SymfonyIndex.addShutdownListener(new IShutdownListener(){

                        @Override
                        public void shutdown() {
                            if (instance != null) {
                                try {
                                    instance.dispose();
                                }
                                catch (SQLException e) {
                                    Logger.logException(e);
                                }
                                instance = null;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Logger.logException(e);
                    instanceLock.release();
                }
            }
            finally {
                instanceLock.release();
            }
        }
        return instance;
    }

    private SymfonyDbFactory() throws Exception {
        IPath dbPath = SymfonyIndex.getDefault().getStateLocation();
        String connString = this.getConnectionString(dbPath);
        this.pool = JdbcConnectionPool.create((String)connString, (String)"", (String)"");
        this.pool.setMaxConnections(100);
        Schema schema = new Schema();
        boolean initializeSchema = false;
        int tries = 2;
        Connection connection = null;
        do {
            try {
                connection = this.pool.getConnection();
                try {
                    block15: {
                        Statement statement = connection.createStatement();
                        try {
                            try {
                                statement.executeQuery("SELECT COUNT(*) FROM SERVICES WHERE 1=0;");
                                initializeSchema = !schema.isCompatible();
                            }
                            catch (SQLException sQLException) {
                                initializeSchema = true;
                                statement.close();
                                break block15;
                            }
                        }
                        catch (Throwable throwable) {
                            statement.close();
                            throw throwable;
                        }
                        statement.close();
                    }
                    if (initializeSchema) {
                        connection.close();
                        this.pool.dispose();
                        DeleteDbFiles.execute((String)dbPath.toOSString(), (String)DB_NAME, (boolean)true);
                        this.pool = JdbcConnectionPool.create((String)connString, (String)"", (String)"");
                        this.pool.setMaxConnections(100);
                        connection = this.pool.getConnection();
                        schema.initialize(connection);
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (SQLException e) {
                Logger.logException(e);
                try {
                    DeleteDbFiles.execute((String)dbPath.toOSString(), (String)DB_NAME, (boolean)true);
                }
                catch (Exception e1) {
                    Logger.logException(e1);
                    throw e1;
                }
            }
        } while (connection == null && --tries > 0);
    }

    private String getConnectionString(IPath dbPath) {
        IPreferencesService preferencesService = Platform.getPreferencesService();
        StringBuilder buf = new StringBuilder("jdbc:h2:").append(dbPath.append(DB_NAME).toOSString());
        buf.append(";UNDO_LOG=0");
        buf.append(";LOCK_MODE=").append(preferencesService.getInt("com.dubture.symfony.index", "db_lock_mode", 0, null));
        buf.append(";CACHE_TYPE=").append(preferencesService.getString("com.dubture.symfony.index", "db_cache_type", null, null));
        buf.append(";CACHE_SIZE=").append(preferencesService.getInt("com.dubture.symfony.index", "db_cache_size", 0, null));
        buf.append(";QUERY_CACHE_SIZE=").append(preferencesService.getInt("com.dubture.symfony.index", "db_query_cache_size", 0, null));
        buf.append(";LARGE_RESULT_BUFFER_SIZE=").append(preferencesService.getInt("com.dubture.symfony.index", "db_large_result_buffer_size", 0, null));
        buf.append(";FILE_LOCK=NO");
        return buf.toString();
    }

    public Connection createConnection() throws SQLException {
        return this.pool == null ? null : this.pool.getConnection();
    }

    public void dispose() throws SQLException {
        if (this.pool != null) {
            this.pool.dispose();
            this.pool = null;
        }
    }

    public IServiceDao getServiceDao() throws SQLException {
        return this.serviceDao;
    }

    public IRouteDao getRouteDao() throws SQLException {
        return this.routeDao;
    }

    public ITransUnitDao getTransDao() throws SQLException {
        return this.transUnitDao;
    }

    public IResourceDao getResourceDao() throws SQLException {
        return this.resourceDao;
    }

    public IParameterDao getParamDao() throws SQLException {
        return this.parameterDao;
    }
}

