/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.index;

import com.dubture.symfony.index.SymfonyDbFactory;
import com.dubture.symfony.index.dao.IParameterDao;
import com.dubture.symfony.index.dao.IResourceDao;
import com.dubture.symfony.index.dao.IRouteDao;
import com.dubture.symfony.index.dao.IServiceDao;
import com.dubture.symfony.index.dao.ITransUnitDao;
import com.dubture.symfony.index.handler.IResourceHandler;
import com.dubture.symfony.index.handler.IServiceHandler;
import com.dubture.symfony.index.handler.ITranslationHandler;
import com.dubture.symfony.index.log.Logger;
import com.dubture.symfony.index.model.Parameter;
import com.dubture.symfony.index.model.Route;
import com.dubture.symfony.index.model.RoutingResource;
import com.dubture.symfony.index.model.TransUnit;
import java.sql.Connection;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class SymfonyIndexer {
    private static SymfonyIndexer instance = null;
    private SymfonyDbFactory factory = SymfonyDbFactory.getInstance();
    private IServiceDao serviceDao = this.factory.getServiceDao();
    private IRouteDao routeDao = this.factory.getRouteDao();
    private IResourceDao resourceDao;
    private ITransUnitDao transDao = this.factory.getTransDao();
    private IParameterDao paramDao;
    private Connection connection;

    private SymfonyIndexer() throws Exception {
        this.resourceDao = this.factory.getResourceDao();
        this.paramDao = this.factory.getParamDao();
        this.connection = SymfonyDbFactory.getInstance().createConnection();
    }

    public static SymfonyIndexer getInstance() throws Exception {
        if (instance == null) {
            instance = new SymfonyIndexer();
        }
        return instance;
    }

    public void addRoute(Route route, IPath path) {
        this.addRoute(route.name, route.pattern, route.controller, route.bundle, route.action, path);
    }

    public void addRoute(String name, String pattern, String controller, String bundle, String action, IPath path) {
        try {
            this.routeDao.deleteRoutesByPath(name, path);
            this.routeDao.insert(this.connection, name, pattern, controller, bundle, action, path);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public void addService(String id, String phpClass, String _public, List<String> tags, String path, int timestamp) {
        try {
            this.serviceDao.delete(id, path);
            this.serviceDao.insert(this.connection, id, phpClass, _public, tags, path, timestamp);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public void deleteServices(String path) {
        this.serviceDao.deleteServices(path);
    }

    public void enterServices(String path) {
        this.serviceDao.deleteServices(path);
        this.paramDao.deleteParameters(path);
    }

    public void exitServices() {
        try {
            this.serviceDao.commitInsertions();
            this.paramDao.commitInsertions();
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public void findServices(String string, IServiceHandler iServiceHandler) {
        this.serviceDao.findServicesByPath(string, iServiceHandler);
    }

    public void findServicesByClassName(String className, String path, IServiceHandler iServiceHandler) {
        this.serviceDao.findServicesByClassName(className, path, iServiceHandler);
    }

    public void findService(String id, String path, IServiceHandler iServiceHandler) {
        this.serviceDao.findService(id, path, iServiceHandler);
    }

    public List<String> findTags(IPath path) {
        return this.serviceDao.findTags(path);
    }

    public void exitRoutes() {
        try {
            this.routeDao.commitInsertions();
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public List<Route> findRoutes(IPath path) {
        try {
            return this.routeDao.findRoutes(path);
        }
        catch (Exception e) {
            Logger.logException(e);
            return null;
        }
    }

    public List<Parameter> findParameters(IPath path) {
        try {
            return this.paramDao.findParameters(path);
        }
        catch (Exception e) {
            Logger.logException(e);
            return null;
        }
    }

    public List<Route> findRoutes(IPath path, String prefix) {
        try {
            return this.routeDao.findRoutes(prefix, path);
        }
        catch (Exception e) {
            Logger.logException(e);
            return null;
        }
    }

    public Route findRoute(String route, IPath path) {
        try {
            return this.routeDao.findRoute(route, path);
        }
        catch (Exception e) {
            Logger.logException(e);
            return null;
        }
    }

    public void addTranslation(TransUnit unit, String path, int timestamp) {
        try {
            this.transDao.deleteRoutesByPath(unit.name, unit.language, path);
            this.transDao.insert(this.connection, path, unit.name, unit.value, unit.language, timestamp);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public void addParameter(String key, String value, IPath path) {
        try {
            this.paramDao.insert(this.connection, key, value, path);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public void exitTranslations() {
        try {
            this.transDao.commitInsertions();
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public void findTranslations(String path, ITranslationHandler iTranslationHandler) {
        this.transDao.findTranslations(path, iTranslationHandler);
    }

    public void findTranslations(String name, String path, ITranslationHandler handler) {
        this.transDao.findTranslations(name, path, handler);
    }

    public List<Route> findRoutesByBundle(String bundleAlias, IPath path) {
        return this.routeDao.findRoutesByBundle(bundleAlias, path);
    }

    public List<Route> findRoutesByController(String bundleAlias, String controller, IPath path) {
        return this.routeDao.findRoutesByController(bundleAlias, controller, path);
    }

    public void addResource(RoutingResource resource, IPath fullPath) {
        try {
            this.resourceDao.insert(this.connection, resource.getPath(), resource.getType(), resource.getPrefix(), fullPath);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public void exitResources() {
        try {
            this.resourceDao.commitInsertions();
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public void findResources(IPath path, IResourceHandler iResourceHandler) {
        this.resourceDao.findResource(path, iResourceHandler);
    }
}

