/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.index.dao.sql;

import com.dubture.symfony.index.dao.IDao;
import com.dubture.symfony.index.log.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseDao
implements IDao {
    protected static final Map<String, String> D_INSERT_QUERY_CACHE = new HashMap<String, String>();
    protected final Map<String, PreparedStatement> batchStatements = new HashMap<String, PreparedStatement>();
    protected final String LIKE_WILDCARD = "%";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitInsertions() throws Exception {
        Map<String, PreparedStatement> map = this.batchStatements;
        synchronized (map) {
            try {
                for (PreparedStatement statement : this.batchStatements.values()) {
                    try {
                        statement.executeBatch();
                    }
                    finally {
                        statement.close();
                    }
                }
            }
            finally {
                this.batchStatements.clear();
            }
        }
    }

    protected String escapeLikePattern(String pattern) {
        return pattern.replaceAll("[\\\\%_]", "\\\\$0");
    }

    protected void closeIfExists(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                Logger.logException(e);
            }
        }
    }
}

