/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.index.dao.sql;

import com.dubture.symfony.index.Schema;
import com.dubture.symfony.index.SymfonyDbFactory;
import com.dubture.symfony.index.dao.IResourceDao;
import com.dubture.symfony.index.dao.sql.BaseDao;
import com.dubture.symfony.index.handler.IResourceHandler;
import com.dubture.symfony.index.log.Logger;
import com.dubture.symfony.index.model.RoutingResource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

public class ResourceDao
extends BaseDao
implements IResourceDao {
    private static final String TABLENAME = "RESOURCE";
    private static final String Q_INSERT_DECL = Schema.readSqlFile("Resources/index/resources/insert_decl.sql");
    private static final String QUERY_FIND_BY_PATH = "SELECT RESOURCEPATH, TYPE, PREFIX FROM RESOURCE WHERE PATH = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Connection connection, String path, String type, String prefix, IPath fullPath) throws Exception {
        String tableName;
        String query;
        if (type == null) {
            type = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        if ((query = (String)D_INSERT_QUERY_CACHE.get(tableName = TABLENAME)) == null) {
            query = NLS.bind((String)Q_INSERT_DECL, (Object)tableName);
            D_INSERT_QUERY_CACHE.put(tableName, query);
        }
        Map map = this.batchStatements;
        synchronized (map) {
            PreparedStatement statement = (PreparedStatement)this.batchStatements.get(query);
            if (statement == null) {
                statement = connection.prepareStatement(query);
                this.batchStatements.put(query, statement);
            }
            this.insertBatch(statement, path, type, prefix, fullPath);
        }
    }

    private void insertBatch(PreparedStatement statement, String resourcePath, String type, String prefix, IPath path) throws SQLException {
        int param = 0;
        statement.setString(++param, resourcePath);
        statement.setString(++param, type);
        statement.setString(++param, prefix);
        statement.setString(++param, path.toString());
        statement.addBatch();
    }

    @Override
    public void findResource(IPath path, IResourceHandler iResourceHandler) {
        Connection connection = null;
        try {
            try {
                connection = SymfonyDbFactory.getInstance().createConnection();
                PreparedStatement statement = connection.prepareStatement(QUERY_FIND_BY_PATH);
                statement.setString(1, path.toString());
                ResultSet result = statement.executeQuery();
                while (result.next()) {
                    int columnIndex = 0;
                    String resourcePath = result.getString(++columnIndex);
                    String type = result.getString(++columnIndex);
                    String prefix = result.getString(++columnIndex);
                    RoutingResource resource = new RoutingResource(type, resourcePath, prefix);
                    iResourceHandler.handle(resource);
                }
            }
            catch (Exception e) {
                Logger.logException(e);
                this.closeIfExists(connection);
            }
        }
        finally {
            this.closeIfExists(connection);
        }
    }
}

