/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.index.dao.sql;

import com.dubture.symfony.index.Schema;
import com.dubture.symfony.index.SymfonyDbFactory;
import com.dubture.symfony.index.dao.IServiceDao;
import com.dubture.symfony.index.dao.sql.BaseDao;
import com.dubture.symfony.index.handler.IServiceHandler;
import com.dubture.symfony.index.log.Logger;
import com.dubture.symfony.index.model.Service;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

public class ServiceDao
extends BaseDao
implements IServiceDao {
    private static final String TABLENAME = "SERVICES";
    private static final String QUERY_TRUNCATE = "TRUNCATE TABLE SERVICES";
    private static final String QUERY_FIND_ALL = "SELECT PATH, NAME, PHPCLASS, _PUBLIC, TAGS  FROM SERVICES";
    private static final String QUERY_FIND_ONE_BY_NAME = "SELECT PATH, NAME, PHPCLASS FROM SERVICES WHERE NAME = ? LIMIT 1";
    private static final String QUERY_FIND_BY_PATH = "SELECT NAME, PHPCLASS, PATH, _PUBLIC, TAGS FROM SERVICES WHERE PATH LIKE ?";
    private static final String QUERY_FIND_BY_PATH_CLASS_NAME = "SELECT NAME, PHPCLASS, PATH, _PUBLIC, TAGS FROM SERVICES WHERE PATH LIKE ? AND ? != ''";
    private static final String QUERY_FIND_ONE_BY_ID_PATH = "SELECT NAME, PHPCLASS, PATH, _PUBLIC, TAGS FROM SERVICES WHERE PATH LIKE ? AND NAME = ? LIMIT 1";
    private static final String QUERY_FIND_TAGS_BY_PATH = "SELECT TAGS FROM SERVICES WHERE PATH LIKE ?";
    private static final String QUERY_DELETE_BY_PATH = "DELETE FROM SERVICES WHERE PATH = ?";
    private static final String QUERY_DELETE_BY_ID_PATH = "DELETE FROM SERVICES WHERE NAME = ? AND PATH = ?";
    private static final String Q_INSERT_DECL = Schema.readSqlFile("Resources/index/insert_decl.sql");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Connection connection, String name, String phpclass, String _public, List<String> tags, String path, int timestamp) throws Exception {
        String tableName = TABLENAME;
        String query = (String)D_INSERT_QUERY_CACHE.get(tableName);
        if (query == null) {
            query = NLS.bind((String)Q_INSERT_DECL, (Object)tableName);
            D_INSERT_QUERY_CACHE.put(tableName, query);
        }
        Map map = this.batchStatements;
        synchronized (map) {
            PreparedStatement statement = (PreparedStatement)this.batchStatements.get(query);
            if (statement == null) {
                statement = connection.prepareStatement(query);
                this.batchStatements.put(query, statement);
            }
            this.insertBatch(statement, path, name, phpclass, _public, tags, timestamp);
        }
    }

    private void insertBatch(PreparedStatement statement, String path, String name, String phpclass, String _public, List<String> tags, int timestamp) throws SQLException {
        int param = 0;
        String tagString = "";
        if (tags != null) {
            int i = 0;
            while (i < tags.size()) {
                tagString = String.valueOf(tagString) + tags.get(i);
                if (i++ < tags.size()) {
                    tagString = String.valueOf(tagString) + ",";
                }
                ++i;
            }
        }
        statement.setString(++param, path);
        statement.setString(++param, name);
        statement.setString(++param, phpclass);
        statement.setString(++param, _public);
        statement.setString(++param, tagString);
        statement.setInt(++param, timestamp);
        statement.addBatch();
    }

    @Override
    public void truncate() {
        Connection connection = null;
        try {
            try {
                connection = SymfonyDbFactory.getInstance().createConnection();
                Statement statement = connection.createStatement();
                statement.execute(QUERY_TRUNCATE);
                connection.commit();
            }
            catch (SQLException e) {
                Logger.logException(e);
                this.closeIfExists(connection);
            }
        }
        finally {
            this.closeIfExists(connection);
        }
    }

    @Override
    public void findAll(IServiceHandler handler) {
        Connection connection = null;
        try {
            try {
                connection = SymfonyDbFactory.getInstance().createConnection();
                Statement statement = connection.createStatement();
                ResultSet result = statement.executeQuery(QUERY_FIND_ALL);
                while (result.next()) {
                    int columnIndex = 0;
                    String path = result.getString(++columnIndex);
                    String name = result.getString(++columnIndex);
                    String phpClass = result.getString(++columnIndex);
                    String _public = result.getString(++columnIndex);
                    String tags = result.getString(++columnIndex);
                    handler.handle(name, path, phpClass, _public, tags);
                }
            }
            catch (Exception e) {
                Logger.logException(e);
                this.closeIfExists(connection);
            }
        }
        finally {
            this.closeIfExists(connection);
        }
    }

    @Override
    public Service find(String name) {
        Connection connection = null;
        try {
            Service service;
            connection = SymfonyDbFactory.getInstance().createConnection();
            PreparedStatement prepareStatement = connection.prepareStatement(QUERY_FIND_ONE_BY_NAME);
            prepareStatement.setString(1, name);
            ResultSet result = prepareStatement.executeQuery();
            result.first();
            String path = result.getString(1);
            String id = result.getString(2);
            String phpClass = result.getString(3);
            Service service2 = service = new Service(id, phpClass, path);
            return service2;
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        finally {
            this.closeIfExists(connection);
        }
        return null;
    }

    @Override
    public void deleteServices(String path) {
        Connection connection = null;
        try {
            try {
                connection = SymfonyDbFactory.getInstance().createConnection();
                PreparedStatement statement = connection.prepareStatement(QUERY_DELETE_BY_PATH);
                statement.setString(1, path);
                statement.execute();
                connection.commit();
            }
            catch (SQLException e) {
                Logger.logException(e);
                this.closeIfExists(connection);
            }
        }
        finally {
            this.closeIfExists(connection);
        }
    }

    @Override
    public void findServicesByPath(String path, IServiceHandler handler) {
        Connection connection = null;
        try {
            try {
                connection = SymfonyDbFactory.getInstance().createConnection();
                PreparedStatement statement = connection.prepareStatement(QUERY_FIND_BY_PATH);
                statement.setString(1, String.valueOf(this.escapeLikePattern(path)) + "%");
                ResultSet result = statement.executeQuery();
                while (result.next()) {
                    int columnIndex = 0;
                    String id = result.getString(++columnIndex);
                    String phpClass = result.getString(++columnIndex);
                    String _path = result.getString(++columnIndex);
                    String _public = result.getString(++columnIndex);
                    String tags = result.getString(++columnIndex);
                    handler.handle(id, phpClass, _path, _public, tags);
                }
            }
            catch (Exception e) {
                Logger.logException(e);
                this.closeIfExists(connection);
            }
        }
        finally {
            this.closeIfExists(connection);
        }
    }

    @Override
    public void findService(String id, String path, IServiceHandler handler) {
        Connection connection = null;
        try {
            connection = SymfonyDbFactory.getInstance().createConnection();
            PreparedStatement statement = connection.prepareStatement(QUERY_FIND_ONE_BY_ID_PATH);
            statement.setString(1, String.valueOf(this.escapeLikePattern(path)) + "%");
            statement.setString(2, id.replaceAll("['\"]", ""));
            ResultSet result = statement.executeQuery();
            result.first();
            if (!result.isFirst()) {
                return;
            }
            try {
                String _id = result.getString(1);
                String _phpClass = result.getString(2);
                String _path = result.getString(3);
                String _public = result.getString(4);
                String _tags = result.getString(5);
                handler.handle(_id, _phpClass, _path, _public, _tags);
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        finally {
            this.closeIfExists(connection);
        }
    }

    @Override
    public void findServicesByClassName(String className, String path, IServiceHandler handler) {
        Connection connection = null;
        try {
            try {
                connection = SymfonyDbFactory.getInstance().createConnection();
                PreparedStatement statement = connection.prepareStatement(QUERY_FIND_BY_PATH_CLASS_NAME);
                statement.setString(1, String.valueOf(this.escapeLikePattern(path)) + "%");
                statement.setString(2, className.replaceAll("['\"]", ""));
                ResultSet result = statement.executeQuery();
                while (result.next()) {
                    int columnIndex = 0;
                    String name = result.getString(++columnIndex);
                    String phpClass = result.getString(++columnIndex);
                    String ppath = result.getString(++columnIndex);
                    String _public = result.getString(++columnIndex);
                    String tags = result.getString(++columnIndex);
                    handler.handle(name, phpClass, ppath, _public, tags);
                }
            }
            catch (Exception e) {
                Logger.logException(e);
                this.closeIfExists(connection);
            }
        }
        finally {
            this.closeIfExists(connection);
        }
    }

    @Override
    public List<String> findTags(IPath path) {
        ArrayList<String> tags = new ArrayList<String>();
        Connection connection = null;
        try {
            try {
                connection = SymfonyDbFactory.getInstance().createConnection();
                PreparedStatement statement = connection.prepareStatement(QUERY_FIND_TAGS_BY_PATH);
                statement.setString(1, String.valueOf(this.escapeLikePattern(path.toString())) + "%");
                ResultSet result = statement.executeQuery();
                while (result.next()) {
                    String[] t;
                    int columnIndex = 0;
                    String _tags = result.getString(++columnIndex);
                    String[] stringArray = t = _tags.split(",");
                    int n = t.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String tag = stringArray[n2];
                        if (!tags.contains(tag)) {
                            tags.add(tag);
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                Logger.logException(e);
                this.closeIfExists(connection);
            }
        }
        finally {
            this.closeIfExists(connection);
        }
        return tags;
    }

    @Override
    public void delete(String id, String path) {
        Connection connection = null;
        try {
            try {
                connection = SymfonyDbFactory.getInstance().createConnection();
                PreparedStatement statement = connection.prepareStatement(QUERY_DELETE_BY_ID_PATH);
                statement.setString(1, id);
                statement.setString(2, path);
                connection.commit();
            }
            catch (SQLException e) {
                Logger.logException(e);
                this.closeIfExists(connection);
            }
        }
        finally {
            this.closeIfExists(connection);
        }
    }
}

