/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.index.model;

import com.dubture.symfony.index.model.RouteParameter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class Route {
    public String name;
    public String pattern;
    public String controller;
    public String action;
    public String bundle;
    private Map<String, RouteParameter> parameters = null;

    public Route(String bundle, String controller, String action, String name, String pattern) {
        this.bundle = bundle;
        this.controller = controller;
        this.action = action;
        this.name = name;
        if (pattern != null) {
            this.pattern = pattern.replace("\"", "").replace("'", "");
        }
    }

    public Route(String name, String pattern, String viewPath) {
        this.name = name;
        this.pattern = pattern;
        StringTokenizer tokenizer = new StringTokenizer(viewPath, ":");
        if (tokenizer.hasMoreTokens()) {
            this.bundle = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            this.controller = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            this.action = tokenizer.nextToken();
        }
    }

    public Route(String name2, String pattern2) {
        this.name = name2;
        this.pattern = pattern2;
    }

    public String toString() {
        return String.valueOf(this.name) + " => " + this.pattern + " => " + this.getViewPath();
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public String getViewPath() {
        return String.format("%s:%s:%s", this.bundle, this.controller, this.action);
    }

    public String getName() {
        return this.name;
    }

    public String getController() {
        return this.controller;
    }

    public boolean hasParameters() {
        return this.pattern != null && this.pattern.contains("{");
    }

    public Map<String, RouteParameter> getParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        this.parameters = new HashMap<String, RouteParameter>();
        if (this.pattern != null) {
            String[] parts;
            String route = this.pattern;
            String[] stringArray = parts = route.split("\\/");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (part.startsWith("{")) {
                    RouteParameter param = new RouteParameter(part);
                    this.parameters.put(param.getName(), param);
                }
                ++n2;
            }
        }
        return this.parameters;
    }

    public String getURL(Collection<RouteParameter> collection, String prefix) {
        if (this.pattern == null) {
            return "";
        }
        String url = this.pattern;
        for (RouteParameter param : collection) {
            String regex = String.format("{%s}", param.getName());
            url = url.replace(regex, param.getValue());
        }
        if (prefix != null) {
            url = String.valueOf(prefix) + url;
        }
        return url;
    }

    public String getURL(String prefix) {
        if (prefix != null) {
            return String.valueOf(prefix) + this.pattern;
        }
        return this.pattern;
    }

    public String getPattern() {
        return this.pattern;
    }
}

