/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.twig.codeassist.strategies;

import com.dubture.symfony.core.model.Bundle;
import com.dubture.symfony.core.model.SymfonyModelAccess;
import com.dubture.symfony.core.model.Translation;
import com.dubture.symfony.index.model.TransUnit;
import com.dubture.symfony.twig.codeassist.CompletionProposalFlag;
import com.dubture.symfony.twig.codeassist.context.TranslationCompletionContext;
import com.dubture.twig.core.codeassist.ICompletionContext;
import com.dubture.twig.core.codeassist.ICompletionProposalFlag;
import com.dubture.twig.core.codeassist.ICompletionReporter;
import com.dubture.twig.core.codeassist.strategies.AbstractTwigCompletionStrategy;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.jface.text.BadLocationException;

public class TranslationCompletionStrategy
extends AbstractTwigCompletionStrategy {
    private TranslationCompletionContext tContext;

    public TranslationCompletionStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws Exception {
        this.tContext = (TranslationCompletionContext)this.getContext();
        IScriptProject project = this.tContext.getScriptProject();
        ISourceRange range = this.getReplacementRange((ICompletionContext)this.tContext);
        SymfonyModelAccess model = SymfonyModelAccess.getDefault();
        String prefix = this.tContext.getPrefix();
        List bundles = model.findBundles(project);
        List units = model.findTranslations(project.getPath());
        for (TransUnit unit : units) {
            Bundle targetBundle = null;
            for (Bundle bundle : bundles) {
                if (!unit.path.startsWith(bundle.getTranslationPath())) continue;
                targetBundle = bundle;
                break;
            }
            if (targetBundle.getScriptProject() == null) {
                targetBundle.setProject(project);
            }
            if (targetBundle == null || !StringUtils.startsWithIgnoreCase((CharSequence)unit.name, (CharSequence)prefix)) continue;
            new Translation((ModelElement)targetBundle, unit);
            reporter.reportKeyword(unit.name, range, new ICompletionProposalFlag[]{CompletionProposalFlag.TRANSLATION});
        }
    }

    public ISourceRange getReplacementRange(ICompletionContext context) throws BadLocationException {
        return new SourceRange(this.tContext.getOffset(), this.tContext.getStatementEnd());
    }
}

