/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.twig.ui;

import com.dubture.symfony.core.builder.SymfonyNature;
import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.model.Bundle;
import com.dubture.symfony.core.model.SymfonyModelAccess;
import com.dubture.symfony.core.model.ViewPath;
import com.dubture.symfony.twig.model.SymfonyTemplateResolver;
import com.dubture.symfony.twig.ui.ViewpathProposalAdapter;
import com.dubture.twig.ui.wizards.ITemplateProvider;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class TemplateProvider
implements ITemplateProvider {
    private SymfonyModelAccess model = SymfonyModelAccess.getDefault();
    private Text parentTemplate;
    private IScriptProject scriptProject;
    private CheckboxTableViewer blockTable;
    private List<String> blocks = new ArrayList<String>();
    private List<String> checkedBlocks = new LinkedList<String>();
    private String parent = "";
    private boolean isValid = true;
    private ContentProposalAdapter contentProposalAdapter;
    private SimpleContentProposalProvider provider;

    public void createContentControls(IScriptFolder folder, Composite container) {
        this.initialize(folder);
        if (!this.isValid) {
            return;
        }
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.heightHint = 20;
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)gd);
        Label parentLabel = new Label(container, 0);
        parentLabel.setText("Parent template:");
        gd = new GridData(768);
        gd.widthHint = 200;
        this.parentTemplate = new Text(container, 2052);
        this.parentTemplate.setLayoutData((Object)gd);
        ControlDecoration dec = new ControlDecoration((Control)this.parentTemplate, 16512);
        FieldDecoration indicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        dec.setImage(indicator.getImage());
        dec.setDescriptionText(String.valueOf(indicator.getDescription()) + "(Ctrl+Space)");
        dec.setShowOnlyOnFocus(true);
        Label filler = new Label(container, 0);
        filler.setVisible(false);
        gd = new GridData();
        gd.verticalAlignment = 128;
        Label blockLabel = new Label(container, 0);
        blockLabel.setText("Override blocks:");
        blockLabel.setLayoutData((Object)gd);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.blockTable = CheckboxTableViewer.newCheckList((Composite)container, (int)2816);
        this.blockTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    if (!TemplateProvider.this.checkedBlocks.contains(event.getElement())) {
                        TemplateProvider.this.checkedBlocks.add((String)event.getElement());
                    }
                } else {
                    TemplateProvider.this.checkedBlocks.remove(event.getElement());
                }
            }
        });
        this.blockTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.blockTable.setInput(this.blocks);
        this.blockTable.getControl().setLayoutData((Object)gridData);
        Logger.debugMSG((String)"Setting up autocomplete");
        this.setupAutocomplete();
        Logger.debugMSG((String)"Controls created");
    }

    private void initialize(IScriptFolder folder) {
        try {
            this.isValid = true;
            if (folder == null) {
                this.isValid = false;
            } else {
                this.scriptProject = folder.getScriptProject();
                if (this.scriptProject == null || !this.scriptProject.getProject().hasNature(SymfonyNature.NATURE_ID)) {
                    this.isValid = false;
                }
            }
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
            this.isValid = false;
        }
    }

    private void setupAutocomplete() {
        try {
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            this.provider = new SimpleContentProposalProvider(new String[0]);
            this.provider.setFiltering(true);
            this.contentProposalAdapter = new ContentProposalAdapter((Control)this.parentTemplate, (IControlContentAdapter)new ViewpathProposalAdapter(), (IContentProposalProvider)this.provider, keyStroke, null);
            this.contentProposalAdapter.setFilterStyle(2);
            this.contentProposalAdapter.setAutoActivationDelay(10);
            this.contentProposalAdapter.setPropagateKeys(true);
            this.contentProposalAdapter.addContentProposalListener(new IContentProposalListener(){

                public void proposalAccepted(IContentProposal proposal) {
                    TemplateProvider.this.parent = proposal.getContent();
                    IModelElement template = TemplateProvider.this.model.findTemplate(new ViewPath(TemplateProvider.this.parent), TemplateProvider.this.scriptProject);
                    if (template != null && template instanceof SourceModule) {
                        try {
                            new SymfonyTemplateResolver();
                        }
                        catch (Exception e) {
                            Logger.logException((Throwable)e);
                        }
                    }
                }
            });
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LinkedList<String> proposals = new LinkedList<String>();
                    List bundles = TemplateProvider.this.model.findBundles(TemplateProvider.this.scriptProject);
                    for (Bundle bundle : bundles) {
                        IModelElement[] rootTemplates;
                        IType[] controllers = TemplateProvider.this.model.findBundleControllers(bundle.getElementName(), TemplateProvider.this.scriptProject);
                        if (controllers == null) continue;
                        IModelElement[] iModelElementArray = rootTemplates = TemplateProvider.this.model.findBundleRootTemplates(bundle.getElementName(), TemplateProvider.this.scriptProject);
                        int n = rootTemplates.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IModelElement tpl = iModelElementArray[n2];
                            String path = String.format("%s::%s", bundle.getElementName(), tpl.getElementName());
                            proposals.add(path);
                            ++n2;
                        }
                        iModelElementArray = controllers;
                        n = controllers.length;
                        n2 = 0;
                        while (n2 < n) {
                            IModelElement[] templates;
                            IModelElement controller = iModelElementArray[n2];
                            IModelElement[] iModelElementArray2 = templates = TemplateProvider.this.model.findTemplates(bundle.getElementName(), controller.getElementName(), TemplateProvider.this.scriptProject);
                            int n3 = templates.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IModelElement template = iModelElementArray2[n4];
                                String path = String.format("%s:%s:%s", bundle.getElementName(), controller.getElementName().replace("Controller", ""), template.getElementName());
                                proposals.add(path);
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                    Logger.debugMSG((String)"Setting proposals");
                    TemplateProvider.this.provider.setProposals(proposals.toArray(new String[proposals.size()]));
                }
            });
        }
        catch (ParseException e) {
            Logger.logException((Throwable)e);
        }
    }

    public String getContents() {
        if (!this.isValid || this.parent == null || this.parent.length() == 0) {
            return "";
        }
        String delim = System.getProperty("line.separator");
        String content = String.format("{%% extends '%s' %%}%s%s", this.parent, delim, delim);
        for (String block : this.checkedBlocks) {
            content = String.valueOf(content) + String.format("{%% block %s %%}%s%s{%% endblock %%}%s%s", block, delim, delim, delim, delim);
        }
        return content;
    }
}

