/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core;

import com.dubture.twig.core.codeassist.ITwigCompletionContextResolver;
import com.dubture.twig.core.codeassist.ITwigCompletionStrategyFactory;
import com.dubture.twig.core.log.Logger;
import com.dubture.twig.core.model.ITemplateResolver;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ExtensionManager {
    public static final String TEMPLATE_RESOLVER_ID = "com.dubture.twig.core.templateResolvers";
    public static final String COMPLETION_CONTEXT_RESOLVERS = "com.dubture.twig.core.completionContextResolvers";
    public static final String COMPLETION_STRATEGY_RESOLVERS = "com.dubture.twig.core.completionStrategyResolvers";
    private static final String ATTR_CLASS = "class";
    private Map<String, Object[]> extensions = new HashMap<String, Object[]>();
    private static ExtensionManager instance = null;

    private ExtensionManager() {
    }

    private void initTemplateResolvers() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATE_RESOLVER_ID);
        LinkedList<ITemplateResolver> resolvers = new LinkedList<ITemplateResolver>();
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object object = e.createExecutableExtension(ATTR_CLASS);
                if (object instanceof ITemplateResolver) {
                    ITemplateResolver provider = (ITemplateResolver)object;
                    resolvers.add(provider);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        this.extensions.put(TEMPLATE_RESOLVER_ID, resolvers.toArray(new ITemplateResolver[resolvers.size()]));
    }

    private void initContextResolvers() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(COMPLETION_CONTEXT_RESOLVERS);
        LinkedList<ITwigCompletionContextResolver> resolvers = new LinkedList<ITwigCompletionContextResolver>();
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object object = e.createExecutableExtension(ATTR_CLASS);
                if (object instanceof ITwigCompletionContextResolver) {
                    resolvers.add((ITwigCompletionContextResolver)object);
                } else {
                    Logger.log(4, "Invalid class for TwigCompletionContextResolvers : " + object.getClass().getName());
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        this.extensions.put(COMPLETION_CONTEXT_RESOLVERS, resolvers.toArray(new ITwigCompletionContextResolver[resolvers.size()]));
    }

    private void initStrategyResolvers() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(COMPLETION_STRATEGY_RESOLVERS);
        LinkedList<ITwigCompletionStrategyFactory> resolvers = new LinkedList<ITwigCompletionStrategyFactory>();
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object object = e.createExecutableExtension(ATTR_CLASS);
                if (object instanceof ITwigCompletionStrategyFactory) {
                    resolvers.add((ITwigCompletionStrategyFactory)object);
                } else {
                    Logger.log(4, "Invalid class for TwigCompletionStrategyResolvers : " + object.getClass().getName());
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        this.extensions.put(COMPLETION_STRATEGY_RESOLVERS, resolvers.toArray(new ITwigCompletionStrategyFactory[resolvers.size()]));
    }

    public static ExtensionManager getInstance() {
        if (instance == null) {
            instance = new ExtensionManager();
        }
        return instance;
    }

    public ITemplateResolver[] getTemplateProviders() {
        if (!this.extensions.containsKey(TEMPLATE_RESOLVER_ID)) {
            this.initTemplateResolvers();
        }
        return (ITemplateResolver[])this.extensions.get(TEMPLATE_RESOLVER_ID);
    }

    public ITwigCompletionContextResolver[] getCompletionContextResolvers() {
        if (!this.extensions.containsKey(COMPLETION_CONTEXT_RESOLVERS)) {
            this.initContextResolvers();
        }
        return (ITwigCompletionContextResolver[])this.extensions.get(COMPLETION_CONTEXT_RESOLVERS);
    }

    public ITwigCompletionStrategyFactory[] getCompletionStrategyResolvers() {
        if (!this.extensions.containsKey(COMPLETION_STRATEGY_RESOLVERS)) {
            this.initStrategyResolvers();
        }
        return (ITwigCompletionStrategyFactory[])this.extensions.get(COMPLETION_STRATEGY_RESOLVERS);
    }
}

