/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core;

import com.dubture.twig.core.model.TwigModelAccess;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class TwigCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.dubture.twig.core";
    public static final String EDITOR_ID = "com.dubture.twig.editor";
    public static final int INTERNAL_ERROR = 10001;
    private static TwigCorePlugin plugin;
    private static final String isDebugMode = "com.dubture.twig.core/debug";

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                TwigModelAccess.getDefault().clearCache();
            }
        };
        workspace.addResourceChangeListener(listener, 8);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        plugin = null;
    }

    public static TwigCorePlugin getDefault() {
        return plugin;
    }

    public static void log(Exception e) {
        TwigCorePlugin.log(new Status(4, PLUGIN_ID, 10001, "Twig core plugin internal error", (Throwable)e));
    }

    private static void log(Status status) {
        TwigCorePlugin.getDefault().getLog().log((IStatus)status);
    }

    public static boolean debug() {
        String debugOption = Platform.getDebugOption((String)isDebugMode);
        return TwigCorePlugin.getDefault().isDebugging() && "true".equalsIgnoreCase(debugOption);
    }
}

