/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.codeassist;

import com.dubture.twig.core.ExtensionManager;
import com.dubture.twig.core.codeassist.CompletionProposal;
import com.dubture.twig.core.codeassist.CompletionRequestor;
import com.dubture.twig.core.codeassist.ICompletionContext;
import com.dubture.twig.core.codeassist.ICompletionProposalFlag;
import com.dubture.twig.core.codeassist.ICompletionReporter;
import com.dubture.twig.core.codeassist.ICompletionStrategy;
import com.dubture.twig.core.codeassist.ITwigCompletionContextResolver;
import com.dubture.twig.core.codeassist.ITwigCompletionStrategyFactory;
import com.dubture.twig.core.log.Logger;
import com.dubture.twig.core.model.IFilter;
import com.dubture.twig.core.model.IFunction;
import com.dubture.twig.core.model.ITag;
import com.dubture.twig.core.model.ITest;
import com.dubture.twig.internal.core.codeassist.CompletionCompanion;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.jface.text.IDocument;

public class TwigCompletionEngine
implements ICompletionReporter {
    private CompletionRequestor requestor;
    private IProgressMonitor monitor;
    private IProject project;
    private ISourceRange sourceRange;

    protected ITwigCompletionContextResolver[] getContextResolvers() {
        return ExtensionManager.getInstance().getCompletionContextResolvers();
    }

    protected ITwigCompletionStrategyFactory[] getStrategyFactories() {
        return ExtensionManager.getInstance().getCompletionStrategyResolvers();
    }

    public void complete(IDocument document) {
        int n;
        int n2;
        ITwigCompletionContextResolver[] contextResolvers = this.getContextResolvers();
        ITwigCompletionStrategyFactory[] strategyFactories = this.getStrategyFactories();
        CompletionCompanion companion = new CompletionCompanion(this.project);
        LinkedList<ICompletionContext> validContexts = new LinkedList<ICompletionContext>();
        try {
            ITwigCompletionContextResolver[] iTwigCompletionContextResolverArray = contextResolvers;
            n2 = contextResolvers.length;
            int n3 = 0;
            while (n3 < n2) {
                ITwigCompletionContextResolver resolver = iTwigCompletionContextResolverArray[n3];
                ICompletionContext[] iCompletionContextArray = resolver.createContexts(this.project);
                n = iCompletionContextArray.length;
                int n4 = 0;
                while (n4 < n) {
                    ICompletionContext ctx = iCompletionContextArray[n4];
                    ctx.init(companion);
                    if (ctx.isValid(document, this.sourceRange.getOffset(), this.monitor)) {
                        validContexts.add(ctx);
                    }
                    ++n4;
                }
                ++n3;
            }
            if (validContexts.size() > 1) {
                Iterator iterator = validContexts.iterator();
                while (iterator.hasNext()) {
                    if (!((ICompletionContext)iterator.next()).isExclusive()) continue;
                    iterator.remove();
                }
            }
        }
        catch (Throwable e) {
            Logger.logException(e);
        }
        ICompletionContext[] result = validContexts.toArray(new ICompletionContext[validContexts.size()]);
        if (this.monitor.isCanceled() || result.length == 0) {
            return;
        }
        ITwigCompletionStrategyFactory[] iTwigCompletionStrategyFactoryArray = strategyFactories;
        int n5 = strategyFactories.length;
        n2 = 0;
        while (n2 < n5) {
            ITwigCompletionStrategyFactory factory = iTwigCompletionStrategyFactoryArray[n2];
            ICompletionStrategy[] iCompletionStrategyArray = factory.create(result);
            int n6 = iCompletionStrategyArray.length;
            n = 0;
            while (n < n6) {
                ICompletionStrategy str = iCompletionStrategyArray[n];
                str.init(companion);
                try {
                    str.apply(this);
                }
                catch (Exception e) {
                    this.requestor.setErrorMessage(e.getMessage());
                    Logger.logException(e);
                }
                if (this.monitor.isCanceled()) {
                    return;
                }
                ++n;
            }
            ++n2;
        }
    }

    public CompletionRequestor getRequestor() {
        return this.requestor;
    }

    public IProject getProject() {
        return this.project;
    }

    public ISourceRange getSourceRange() {
        return this.sourceRange;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setRequestor(CompletionRequestor requestor) {
        this.requestor = requestor;
    }

    public void setSourceRange(ISourceRange sourceRange) {
        this.sourceRange = sourceRange;
    }

    @Override
    public void acceptProposal(CompletionProposal proposal) {
        this.requestor.acceptProposal(proposal);
    }

    @Override
    public void reportResource(IPath path, ISourceRange position) {
        this.reportResource(path, position, ICompletionProposalFlag.NO_FLAGS);
    }

    @Override
    public void reportResource(IPath path, ISourceRange position, ICompletionProposalFlag[] flags) {
        this.reportResource(path, null, position, flags);
    }

    @Override
    public void reportResource(IPath path, String completion, ISourceRange position, ICompletionProposalFlag[] flags) {
        CompletionProposal proposal = new CompletionProposal(6);
        proposal.setCompletion(completion == null ? path.toString() : completion);
        proposal.setFlags(flags);
        proposal.setName(path.lastSegment());
        proposal.setReplaceRange(position.getOffset(), position.getOffset() + position.getLength());
        this.acceptProposal(proposal);
    }

    @Override
    public void reportFilter(IFilter filter, ISourceRange position) {
        this.reportFilter(filter, position, ICompletionProposalFlag.NO_FLAGS);
    }

    @Override
    public void reportFilter(IFilter filter, ISourceRange position, ICompletionProposalFlag[] flags) {
        this.reportFilter(filter, null, position, flags);
    }

    @Override
    public void reportFilter(IFilter filter, String completion, ISourceRange position, ICompletionProposalFlag[] flags) {
        CompletionProposal proposal = new CompletionProposal(7);
        proposal.setCompletion(completion == null ? filter.getElementName() : completion);
        proposal.setFlags(flags);
        proposal.setReplaceRange(position.getOffset(), position.getOffset() + position.getLength());
        proposal.setName(filter.getElementName());
        proposal.setModelElement(filter);
        proposal.setParameterNames(filter.getParameterNames());
        this.acceptProposal(proposal);
    }

    @Override
    public void reportFunction(IFunction function, ISourceRange position) {
        this.reportFunction(function, position, ICompletionProposalFlag.NO_FLAGS);
    }

    @Override
    public void reportFunction(IFunction function, ISourceRange position, ICompletionProposalFlag[] flags) {
        this.reportFunction(function, null, position, flags);
    }

    @Override
    public void reportFunction(IFunction function, String completion, ISourceRange position, ICompletionProposalFlag[] flags) {
        CompletionProposal proposal = new CompletionProposal(5);
        proposal.setCompletion(completion == null ? function.getElementName() : completion);
        proposal.setFlags(flags);
        proposal.setReplaceRange(position.getOffset(), position.getOffset() + position.getLength());
        proposal.setName(function.getElementName());
        proposal.setModelElement(function);
        proposal.setParameterNames(function.getParameterNames());
        this.acceptProposal(proposal);
    }

    @Override
    public void reportTag(ITag tag, ISourceRange position) {
        this.reportTag(tag, position, ICompletionProposalFlag.NO_FLAGS);
    }

    @Override
    public void reportTag(ITag tag, ISourceRange position, ICompletionProposalFlag[] flags) {
        this.reportTag(tag, null, position, flags);
    }

    @Override
    public void reportTag(ITag tag, String completion, ISourceRange position, ICompletionProposalFlag[] flags) {
        CompletionProposal proposal = new CompletionProposal(8);
        proposal.setCompletion(completion == null ? tag.getElementName() : completion);
        proposal.setFlags(flags);
        proposal.setReplaceRange(position.getOffset(), position.getOffset() + position.getLength());
        proposal.setName(tag.getElementName());
        proposal.setModelElement(tag);
        this.acceptProposal(proposal);
    }

    @Override
    public void reportTest(ITest test, ISourceRange position) {
        this.reportTest(test, position, ICompletionProposalFlag.NO_FLAGS);
    }

    @Override
    public void reportTest(ITest test, ISourceRange position, ICompletionProposalFlag[] flags) {
        this.reportTest(test, null, position, flags);
    }

    @Override
    public void reportTest(ITest test, String completion, ISourceRange position, ICompletionProposalFlag[] flags) {
        CompletionProposal proposal = new CompletionProposal(3);
        proposal.setCompletion(completion == null ? test.getElementName() : completion);
        proposal.setFlags(flags);
        proposal.setReplaceRange(position.getOffset(), position.getOffset() + position.getLength());
        proposal.setName(test.getElementName());
        proposal.setModelElement(test);
        this.acceptProposal(proposal);
    }

    @Override
    public void reportKeyword(String keyword, ISourceRange position) {
        this.reportKeyword(keyword, position, ICompletionProposalFlag.NO_FLAGS);
    }

    @Override
    public void reportKeyword(String keyword, ISourceRange position, ICompletionProposalFlag[] flags) {
        CompletionProposal proposal = new CompletionProposal(2);
        proposal.setName(keyword);
        proposal.setCompletion(keyword);
        proposal.setFlags(flags);
        proposal.setReplaceRange(position.getOffset(), position.getOffset() + position.getLength());
        this.acceptProposal(proposal);
    }
}

