/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.codeassist.context;

import com.dubture.twig.core.TwigCorePlugin;
import com.dubture.twig.core.codeassist.ICompletionCompanion;
import com.dubture.twig.core.codeassist.ICompletionContext;
import com.dubture.twig.core.documentModel.parser.regions.ITwigScriptRegion;
import com.dubture.twig.core.util.text.TwigTextSequenceUtilities;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class AbstractTwigCompletionContext
implements ICompletionContext {
    private IStructuredDocument document;
    private int offset;
    private IStructuredDocumentRegion structuredDocumentRegion;
    private ITextRegionCollection regionCollection;
    private ITwigScriptRegion twigScriptRegion;
    private String partitionType;
    private ICompletionCompanion companion;

    public ITwigScriptRegion getTwigScriptRegion() {
        return this.twigScriptRegion;
    }

    protected String determinePartitionType(ITextRegionCollection regionCollection, ITwigScriptRegion twigScriptRegion, int offset) throws BadLocationException {
        String regionType;
        int internalOffset = offset - regionCollection.getStartOffset() - twigScriptRegion.getStart() - 1;
        String partitionType = twigScriptRegion.getPartition(internalOffset);
        if (!(partitionType != "org.eclipse.php.PHP_MULTI_LINE_COMMENT" && partitionType != "org.eclipse.php.PHP_DOC" || (regionType = twigScriptRegion.getTwigToken(internalOffset).getType()) != "PHP_COMMENT_START" && regionType != "PHPDOC_COMMENT_START" || twigScriptRegion.getTwigToken(internalOffset).getStart() != internalOffset)) {
            partitionType = twigScriptRegion.getPartition(internalOffset - 1);
        }
        return partitionType;
    }

    protected ITwigScriptRegion determineTwigRegion(IStructuredDocument document, ITextRegionCollection regionCollection, int offset) {
        ITextRegion textRegion = this.determineTextRegion(document, regionCollection, offset);
        this.twigScriptRegion = null;
        if (textRegion instanceof ITwigScriptRegion) {
            this.twigScriptRegion = (ITwigScriptRegion)textRegion;
        }
        return this.twigScriptRegion;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    protected IStructuredDocumentRegion determineStructuredDocumentRegion(IStructuredDocument document, int offset) {
        IStructuredDocumentRegion sdRegion = null;
        int lastOffset = offset;
        while (sdRegion == null && lastOffset >= 0) {
            sdRegion = document.getRegionAtCharacterOffset(lastOffset);
            --lastOffset;
        }
        return sdRegion;
    }

    protected ITextRegionCollection determineRegionCollection(IStructuredDocument document, IStructuredDocumentRegion sdRegion, int offset) {
        IStructuredDocumentRegion regionCollection = sdRegion;
        ITextRegion textRegion = this.determineTextRegion(document, (ITextRegionCollection)sdRegion, offset);
        if (textRegion instanceof ITextRegionContainer) {
            regionCollection = (ITextRegionContainer)textRegion;
        }
        return regionCollection;
    }

    protected ITextRegion determineTextRegion(IStructuredDocument document, ITextRegionCollection regionCollection, int offset) {
        ITextRegion textRegion = offset == document.getLength() ? regionCollection.getLastRegion() : regionCollection.getRegionAtCharacterOffset(offset);
        return textRegion;
    }

    public IStructuredDocument getDocument() {
        return this.document;
    }

    public ITextRegionCollection getRegionCollection() {
        return this.regionCollection;
    }

    public String getPartitionType() {
        return this.partitionType;
    }

    public TextSequence getStatementText() {
        return TwigTextSequenceUtilities.getStatement(this.offset, this.structuredDocumentRegion, true);
    }

    public boolean hasWhitespaceBeforeCursor() {
        int statementEnd;
        TextSequence statementText = this.getStatementText();
        assert (statementText != null);
        int statementLength = statementText.length();
        return statementLength != (statementEnd = PHPTextSequenceUtilities.readBackwardSpaces((CharSequence)statementText, (int)statementLength));
    }

    public int getOffset() {
        return this.offset;
    }

    public String getPreviousWord() throws BadLocationException {
        int statementLength;
        int wordEnd;
        TextSequence statementText = this.getStatementText();
        int wordStart = PHPTextSequenceUtilities.readNamespaceStartIndex((CharSequence)statementText, (int)(wordEnd = PHPTextSequenceUtilities.readBackwardSpaces((CharSequence)statementText, (int)(statementLength = statementText.length()))), (boolean)true);
        if (wordStart < 0 || wordEnd < 0 || wordStart > wordEnd) {
            return "";
        }
        String previousWord = statementText.subSequence(wordStart, wordEnd).toString();
        if (this.hasWhitespaceBeforeCursor()) {
            return previousWord;
        }
        wordEnd = PHPTextSequenceUtilities.readBackwardSpaces((CharSequence)statementText, (int)(wordStart - 1));
        if ((wordStart = PHPTextSequenceUtilities.readNamespaceStartIndex((CharSequence)statementText, (int)wordEnd, (boolean)true)) < 0 || wordEnd < 0 || wordStart > wordEnd) {
            return "";
        }
        previousWord = statementText.subSequence(wordStart, wordEnd).toString();
        return previousWord;
    }

    public String getPreviousWord(int times) throws BadLocationException {
        TextSequence statementText = this.getStatementText();
        int statementLength = statementText.length();
        int wordEnd = PHPTextSequenceUtilities.readBackwardSpaces((CharSequence)statementText, (int)statementLength);
        int wordStart = PHPTextSequenceUtilities.readNamespaceStartIndex((CharSequence)statementText, (int)wordEnd, (boolean)true);
        int i = 0;
        while (i < times - 1) {
            statementLength = wordStart;
            wordEnd = PHPTextSequenceUtilities.readBackwardSpaces((CharSequence)statementText, (int)statementLength);
            wordStart = PHPTextSequenceUtilities.readNamespaceStartIndex((CharSequence)statementText, (int)wordEnd, (boolean)true);
            ++i;
        }
        if (wordStart < 0 || wordEnd < 0 || wordStart > wordEnd) {
            return "";
        }
        String previousWord = statementText.subSequence(wordStart, wordEnd).toString();
        if (this.hasWhitespaceBeforeCursor()) {
            return previousWord;
        }
        wordEnd = PHPTextSequenceUtilities.readBackwardSpaces((CharSequence)statementText, (int)(wordStart - 1));
        if ((wordStart = PHPTextSequenceUtilities.readNamespaceStartIndex((CharSequence)statementText, (int)wordEnd, (boolean)true)) < 0 || wordEnd < 0 || wordStart > wordEnd) {
            return "";
        }
        previousWord = statementText.subSequence(wordStart, wordEnd).toString();
        return previousWord;
    }

    public ITextRegion getTwigToken() throws BadLocationException {
        return this.getTwigToken(this.offset);
    }

    public ITextRegion getTwigToken(int offset) throws BadLocationException {
        return this.twigScriptRegion.getTwigToken(offset - this.regionCollection.getStartOffset() - this.twigScriptRegion.getStart() - 1);
    }

    public String getPrefix() throws BadLocationException {
        return this.getPrefixWithoutProcessing();
    }

    public String getPrefixWithoutProcessing() {
        if (this.hasWhitespaceBeforeCursor()) {
            return "";
        }
        TextSequence statementText = this.getStatementText();
        int statementLength = statementText.length();
        int prefixEnd = PHPTextSequenceUtilities.readBackwardSpaces((CharSequence)statementText, (int)statementLength);
        int prefixStart = TwigTextSequenceUtilities.readIdentifierStartIndex(statementText, prefixEnd);
        return statementText.subSequence(prefixStart, prefixEnd).toString();
    }

    public int getPrefixEnd() throws BadLocationException {
        ITextRegion phpToken = this.getTwigToken();
        int endOffset = this.regionCollection.getStartOffset() + this.twigScriptRegion.getStart() + phpToken.getTextEnd();
        if (phpToken.getType() == "PHP_CONSTANT_ENCAPSED_STRING") {
            --endOffset;
        }
        return endOffset;
    }

    public ITextRegion getNextTwigToken() throws BadLocationException {
        ITextRegion twigToken = this.getTwigToken();
        while ((PHPPartitionTypes.isPHPCommentState((String)(twigToken = this.twigScriptRegion.getTwigToken(twigToken.getEnd())).getType()) || twigToken.getType() == "WHITESPACE") && twigToken.getEnd() < this.twigScriptRegion.getLength()) {
        }
        return twigToken;
    }

    public ITextRegion getNextTwigToken(int times) throws BadLocationException {
        ITextRegion twigToken = null;
        int offset = this.offset;
        while (times-- > 0) {
            twigToken = this.getTwigToken(offset);
            while ((PHPPartitionTypes.isPHPCommentState((String)(twigToken = this.twigScriptRegion.getTwigToken(twigToken.getEnd())).getType()) || twigToken.getType() == "WHITESPACE") && twigToken.getEnd() < this.twigScriptRegion.getLength()) {
            }
            if (twigToken == null) {
                return null;
            }
            offset = this.regionCollection.getStartOffset() + this.twigScriptRegion.getStart() + twigToken.getEnd();
        }
        return twigToken;
    }

    public String getNextWord() throws BadLocationException {
        ITextRegion nextTwigToken = this.getNextTwigToken();
        return this.document.get(this.regionCollection.getStartOffset() + this.twigScriptRegion.getStart() + nextTwigToken.getStart(), nextTwigToken.getTextLength());
    }

    public String getNextWord(int times) throws BadLocationException {
        ITextRegion nextTwigToken = this.getNextTwigToken(times);
        return this.document.get(this.regionCollection.getStartOffset() + this.twigScriptRegion.getStart() + nextTwigToken.getStart(), nextTwigToken.getTextLength());
    }

    public char getNextChar() throws BadLocationException {
        if (this.document.getLength() == this.offset) {
            return ' ';
        }
        return this.document.getChar(this.offset);
    }

    @Override
    public boolean isValid(IDocument template, int offset, IProgressMonitor monitor) {
        this.offset = offset;
        if (!(template instanceof IStructuredDocument)) {
            return true;
        }
        this.document = (IStructuredDocument)template;
        try {
            if (this.document != null) {
                this.structuredDocumentRegion = this.determineStructuredDocumentRegion(this.document, offset);
                if (this.structuredDocumentRegion != null) {
                    this.regionCollection = this.determineRegionCollection(this.document, this.structuredDocumentRegion, offset);
                    if (this.regionCollection != null) {
                        this.twigScriptRegion = this.determineTwigRegion(this.document, this.regionCollection, offset);
                        if (this.twigScriptRegion != null) {
                            this.partitionType = this.determinePartitionType(this.regionCollection, this.twigScriptRegion, offset);
                            return true;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            TwigCorePlugin.log(e);
        }
        return false;
    }

    @Override
    public void init(ICompletionCompanion companion) {
        this.companion = companion;
    }

    public ICompletionCompanion getCompletionCompanion() {
        return this.companion;
    }

    public IProject getProject() {
        return this.companion.getProject();
    }

    public IScriptProject getScriptProject() {
        IProject project = this.getProject();
        if (project != null) {
            return DLTKCore.create((IProject)project);
        }
        return null;
    }
}

