/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.codeassist.context;

import com.dubture.twig.core.codeassist.context.AbstractTwigCompletionContext;
import com.dubture.twig.core.log.Logger;
import com.dubture.twig.core.parser.SourceParserUtil;
import com.dubture.twig.core.parser.ast.node.BlockStatement;
import com.dubture.twig.core.parser.ast.node.TwigModuleDeclaration;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;

public class BlocknameContext
extends AbstractTwigCompletionContext {
    protected TwigModuleDeclaration module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid(IDocument template, int offset, IProgressMonitor monitor) {
        if (!super.isValid(template, offset, monitor)) {
            return false;
        }
        try {
            BlockStatement block;
            if (this.getPartitionType() == "com.dubture.twig.TWIG_QUOTED_STRING") {
                return false;
            }
            String prefix = this.getStatementText().toString();
            if (prefix.contains(".") || prefix.contains("\"") || prefix.contains("'")) return false;
            String previous = this.getPreviousWord();
            if (previous == null || !"block".equals(previous)) {
                return false;
            }
            this.module = (TwigModuleDeclaration)SourceParserUtil.parseSourceModule(template.get());
            Iterator<BlockStatement> iterator = this.module.getBlocks().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!"extends".equals((block = iterator.next()).getName().getValue()));
            return true;
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return false;
    }

    public TwigModuleDeclaration getModule() {
        return this.module;
    }
}

