/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.documentModel;

import com.dubture.twig.core.TwigCorePlugin;
import org.eclipse.dltk.internal.core.util.LRUCache;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.document.XMLModelParser;

public class TwigDOMModelParser
extends XMLModelParser {
    public static final String TWIG_PRINT_TAG = "print";
    public static final String TWIG_STMT_TAG = "statement";
    private final LRUCache cache = new LRUCache();

    public TwigDOMModelParser(DOMModelImpl model) {
        super(model);
    }

    protected boolean isNestedContent(String regionType) {
        return regionType == "TWIG_CONTENT";
    }

    protected boolean isNestedTag(String regionType) {
        return regionType == "TWIG_STMT_OPEN" || regionType == "TWIG_OPEN" || regionType == "TWIG_CLOSE" || regionType == "TWIG_STMT_CLOSE";
    }

    protected boolean isNestedTagOpen(String regionType) {
        return regionType == "TWIG_STMT_OPEN" || regionType == "TWIG_OPEN";
    }

    protected String computeNestedTag(String regionType, String tagName, IStructuredDocumentRegion structuredDocumentRegion, ITextRegion region) {
        if (regionType.equals("TWIG_STMT_OPEN")) {
            try {
                String text = structuredDocumentRegion.getText();
                Object cached = this.cache.get((Object)text);
                if (cached != null) {
                    return (String)cached;
                }
            }
            catch (Exception e) {
                TwigCorePlugin.log(e);
            }
            return TWIG_STMT_TAG;
        }
        if (regionType.equals("TWIG_OPEN")) {
            return TWIG_PRINT_TAG;
        }
        return TWIG_STMT_TAG;
    }

    protected boolean isNestedTagClose(String regionType) {
        return regionType == "TWIG_STMT_CLOSE" || regionType == "TWIG_CLOSE";
    }
}

