/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.documentModel.parser;

import com.dubture.twig.core.documentModel.parser.TwigTokenizer;
import com.dubture.twig.core.documentModel.parser.regions.TwigRegionTypes;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Segment;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.php.internal.core.documentModel.parser.Scanner;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.preferences.TaskPatternsProvider;
import org.eclipse.php.internal.core.util.collections.StateStack;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public abstract class AbstractTwigLexer
implements Scanner,
TwigRegionTypes {
    protected TwigTokenizer tokenizer = null;
    public static final int YYEOF = -1;
    protected int defaultReturnValue = -1;
    protected int firstPos = -1;
    protected StateStack twigStack;
    public LinkedList<ITextRegion> bufferedTokens = null;
    public int bufferedLength = 0;
    public Scanner.LexerState bufferedState = null;
    private Pattern[] todos;

    public void setTokenizer(TwigTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    protected abstract int getZZEndRead();

    protected abstract int getZZLexicalState();

    protected abstract int getZZMarkedPos();

    protected abstract int getZZPushBackPosition();

    protected abstract int getZZStartRead();

    protected abstract void pushBack(int var1);

    public abstract char[] getZZBuffer();

    public abstract void yybegin(int var1);

    public abstract int yylength();

    public abstract String yytext();

    public abstract void reset(Reader var1, char[] var2, int[] var3);

    public abstract int yystate();

    public abstract int[] getParamenters();

    protected static final boolean isLowerCase(String text) {
        if (text == null) {
            return false;
        }
        int i = 0;
        while (i < text.length()) {
            if (!Character.isLowerCase(text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int buildStateKey() {
        int rv = this.getZZLexicalState();
        int i = 0;
        while (i < this.twigStack.size()) {
            rv = 31 * rv + this.twigStack.get(i);
            ++i;
        }
        return rv;
    }

    @NonNull
    public Scanner.LexerState createLexicalStateMemento() {
        if (this.bufferedTokens != null && !this.bufferedTokens.isEmpty()) {
            assert (this.bufferedState != null);
            return this.bufferedState;
        }
        Scanner.LexerState currentState = this.buildLexerState();
        Scanner.LexerState cachedState = this.getLexerStates().get(currentState);
        if (cachedState != null) {
            return cachedState;
        }
        this.getLexerStates().put(currentState, currentState);
        return currentState;
    }

    private Scanner.LexerState buildLexerState() {
        BasicLexerState state = new BasicLexerState(this);
        return state;
    }

    protected abstract Map<Scanner.LexerState, Scanner.LexerState> getLexerStates();

    public Scanner.LexerState getEndingState() throws IOException {
        this.lexToEnd();
        return this.createLexicalStateMemento();
    }

    public int getFirstIndex() {
        return this.firstPos;
    }

    public int getMarkedPos() {
        return this.getZZMarkedPos();
    }

    public void getText(int start, int length, Segment s) {
        if (start + length > this.getZZEndRead()) {
            throw new RuntimeException("bad segment !!");
        }
        s.array = this.getZZBuffer();
        s.offset = start;
        s.count = length;
    }

    public int getTokenStart() {
        return this.getZZStartRead() - this.getZZPushBackPosition();
    }

    public void initialize(int state) {
        this.twigStack = new StateStack();
        this.yybegin(state);
    }

    public String lexToEnd() throws IOException {
        String curr;
        String last = curr = this.yylex();
        while (curr != null) {
            last = curr;
            curr = this.yylex();
        }
        return last;
    }

    public String lexToTokenAt(int offset) throws IOException {
        if (this.firstPos + offset < this.getZZMarkedPos()) {
            throw new RuntimeException("Bad offset");
        }
        String t = this.yylex();
        while (this.getZZMarkedPos() < this.firstPos + offset && t != null) {
            t = this.yylex();
        }
        return t;
    }

    protected void popState() {
        this.yybegin(this.twigStack.popStack());
    }

    protected void pushState(int state) {
        this.twigStack.pushStack(this.getZZLexicalState());
        this.yybegin(state);
    }

    public void setState(Object state) {
        ((Scanner.LexerState)state).restoreState((Scanner)this);
    }

    public int yystart() {
        return this.getZZStartRead();
    }

    public String getNextToken() throws IOException {
        if (this.bufferedTokens != null) {
            if (this.bufferedTokens.isEmpty()) {
                this.bufferedTokens = null;
            } else {
                return this.removeFromBuffer();
            }
        }
        this.bufferedState = this.createLexicalStateMemento();
        String yylex = this.yylex();
        if (yylex == "PHPDOC_COMMENT") {
            StringBuffer buffer = new StringBuffer();
            int length = 0;
            while (yylex == "PHPDOC_COMMENT") {
                buffer.append(this.yytext());
                yylex = this.yylex();
                ++length;
            }
            this.bufferedTokens = new LinkedList();
            this.bufferedTokens.add((ITextRegion)new ContextRegion(yylex, 0, this.yylength(), this.yylength()));
            yylex = this.removeFromBuffer();
        } else if (PHPPartitionTypes.isPHPCommentState((String)yylex)) {
            this.bufferedTokens = new LinkedList();
            yylex = this.removeFromBuffer();
        }
        if (yylex == "TWIG_CLOSETAG" || yylex == "TWIG_STMT_CLOSE" || yylex == "TWIG_COMMENT_CLOSE") {
            this.pushBack(this.getLength());
        }
        return yylex;
    }

    private String removeFromBuffer() {
        ITextRegion region = this.bufferedTokens.removeFirst();
        this.bufferedLength = region.getLength();
        return region.getType();
    }

    public int getLength() {
        return this.bufferedTokens == null ? this.yylength() : this.bufferedLength;
    }

    public void setPatterns(IProject project) {
        this.todos = project != null ? TaskPatternsProvider.getInstance().getPatternsForProject(project) : TaskPatternsProvider.getInstance().getPatternsForWorkspace();
    }

    private ArrayList<Matcher> createMatcherList(String content) {
        ArrayList<Matcher> list = new ArrayList<Matcher>(this.todos.length);
        int i = 0;
        while (i < this.todos.length) {
            list.add(i, this.todos[i].matcher(content));
            ++i;
        }
        return list;
    }

    private Matcher getMinimalMatcher(ArrayList<Matcher> matchers, int startPosition) {
        Matcher minimal = null;
        int size = matchers.size();
        int i = 0;
        while (i < size) {
            Matcher tmp = matchers.get(i);
            if (tmp.find(startPosition)) {
                if (minimal == null || tmp.start() < minimal.start()) {
                    minimal = tmp;
                }
                ++i;
                continue;
            }
            matchers.remove(i);
            --size;
        }
        return minimal;
    }

    protected void reportError() {
    }

    private static class BasicLexerState
    implements Scanner.LexerState {
        private final byte lexicalState;
        private StateStack twigStack;

        public BasicLexerState(AbstractTwigLexer lexer) {
            if (!lexer.twigStack.isEmpty()) {
                this.twigStack = lexer.twigStack.createClone();
            }
            this.lexicalState = (byte)lexer.getZZLexicalState();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof BasicLexerState)) {
                return false;
            }
            BasicLexerState tmp = (BasicLexerState)o;
            if (tmp.lexicalState != this.lexicalState) {
                return false;
            }
            if (this.twigStack != null && !this.twigStack.equals((Object)tmp.twigStack)) {
                return false;
            }
            return this.twigStack == tmp.twigStack;
        }

        public boolean equalsCurrentStack(Scanner.LexerState obj) {
            StateStack otherActiveStack;
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BasicLexerState)) {
                return false;
            }
            BasicLexerState tmp = (BasicLexerState)obj;
            if (tmp.lexicalState != this.lexicalState) {
                return false;
            }
            StateStack activeStack = this.getActiveStack();
            return activeStack == (otherActiveStack = tmp.getActiveStack()) || activeStack != null && activeStack.equals((Object)otherActiveStack);
        }

        public boolean equalsTop(Scanner.LexerState obj) {
            return obj != null && obj.getTopState() == this.lexicalState;
        }

        protected StateStack getActiveStack() {
            return this.twigStack;
        }

        public int getTopState() {
            return this.lexicalState;
        }

        public boolean isSubstateOf(int state) {
            if (this.lexicalState == state) {
                return true;
            }
            StateStack activeStack = this.getActiveStack();
            if (activeStack == null) {
                return false;
            }
            return activeStack.contains(state);
        }

        public void restoreState(Scanner scanner) {
            AbstractTwigLexer lexer = (AbstractTwigLexer)scanner;
            if (this.twigStack == null) {
                lexer.twigStack.clear();
            } else {
                lexer.twigStack.copyFrom(this.twigStack);
            }
            lexer.yybegin(this.lexicalState);
        }

        public String toString() {
            StateStack stack = this.getActiveStack();
            String stackStr = stack == null ? "null" : stack.toString();
            return "Stack: " + stackStr + ", currState: " + this.lexicalState;
        }

        public int getFirstState() {
            if (this.twigStack != null && !this.twigStack.isEmpty()) {
                return this.twigStack.get(this.twigStack.size() - 1);
            }
            return this.lexicalState;
        }
    }
}

