/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.documentModel.parser;

import com.dubture.twig.core.log.Logger;
import com.dubture.twig.core.parser.SourceParserUtil;
import com.dubture.twig.core.parser.ast.node.BlockStatement;
import com.dubture.twig.core.parser.ast.node.StringLiteral;
import com.dubture.twig.core.parser.ast.node.Variable;
import com.dubture.twig.core.parser.ast.visitor.TwigASTVisitor;
import com.dubture.twig.core.util.TwigModelUtils;
import java.io.StringReader;
import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.php.core.compiler.PHPSourceElementRequestorExtension;

public class TwigSourceElementRequestorExtension
extends PHPSourceElementRequestorExtension {
    public static String PRINT_START = "{{";
    public static String PRINT_END = "}}";
    public static String STMT_START = "{%";
    public static String STMT_END = "%}";

    public void setSourceModule(IModuleSource sourceModule) {
        try {
            super.setSourceModule(sourceModule);
            if (!TwigModelUtils.isTwigTemplate(sourceModule.getFileName())) {
                return;
            }
            String source = sourceModule.getSourceContents();
            this.fRequestor.enterModule();
            ModuleDeclaration decl = SourceParserUtil.parseSourceModule(new StringReader(source));
            decl.traverse((ASTVisitor)new TwigASTVisitor(){

                @Override
                public boolean visit(BlockStatement block) throws Exception {
                    Statement first;
                    if ("block".equals(block.getName().getValue())) {
                        Variable name = block.getBlockName();
                        if (name == null) {
                            return false;
                        }
                        List statements = block.getChilds();
                        IElementRequestor.MethodInfo info = new IElementRequestor.MethodInfo();
                        info.nameSourceStart = name.sourceStart();
                        info.nameSourceEnd = name.sourceEnd() - 1;
                        info.declarationStart = block.sourceStart();
                        info.name = name.getValue();
                        TwigSourceElementRequestorExtension.this.fRequestor.enterMethod(info);
                        if (statements.size() > 1) {
                            TwigSourceElementRequestorExtension.this.fRequestor.exitMethod(block.sourceEnd());
                        }
                    } else if ("extends".equals(block.getName().getValue()) && (first = block.getFirstChild()) instanceof StringLiteral) {
                        StringLiteral parent = (StringLiteral)first;
                        String display = "extends " + parent.getValue();
                        TwigSourceElementRequestorExtension.this.fRequestor.acceptPackage(block.sourceStart(), block.sourceEnd(), display);
                    }
                    return false;
                }

                @Override
                public boolean endvisit(BlockStatement block) throws Exception {
                    if ("endblock".equals(block.getName().getValue())) {
                        TwigSourceElementRequestorExtension.this.fRequestor.exitMethod(block.sourceEnd());
                    }
                    return false;
                }

                @Override
                public boolean endvisit(Variable s) throws Exception {
                    IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
                    info.declarationStart = s.sourceStart();
                    info.nameSourceStart = s.sourceStart();
                    info.nameSourceEnd = s.sourceEnd();
                    info.name = s.getValue();
                    info.modifiers = 64;
                    TwigSourceElementRequestorExtension.this.fRequestor.enterField(info);
                    TwigSourceElementRequestorExtension.this.fRequestor.exitField(s.sourceEnd());
                    return false;
                }
            });
            this.fRequestor.exitModule(decl.sourceEnd());
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }
}

