/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.documentModel.parser;

import com.dubture.twig.core.documentModel.parser.TwigTokenizer;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockTokenizer;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.xml.core.internal.parser.XMLSourceParser;

public class TwigSourceParser
extends XMLSourceParser {
    public static ThreadLocal editFile = new ThreadLocal();
    private IStructuredDocumentRegion headNode = null;
    private IStructuredDocumentRegion lastNode = null;
    private IStructuredDocumentRegion currentNode = null;

    public TwigSourceParser() {
        IResource resource = (IResource)editFile.get();
        if (!(resource instanceof IProject) && resource instanceof IFile) {
            ((IFile)resource).getProject();
        }
    }

    public IStructuredDocumentRegion getDocumentRegions() {
        return super.getDocumentRegions();
    }

    public BlockTokenizer getTokenizer() {
        if (this.fTokenizer == null) {
            TwigTokenizer twigTokenizer = new TwigTokenizer();
            this.fTokenizer = twigTokenizer;
        }
        return this.fTokenizer;
    }

    public RegionParser newInstance() {
        TwigSourceParser newInstance = new TwigSourceParser();
        TwigTokenizer tokenizer = (TwigTokenizer)this.getTokenizer().newInstance();
        newInstance.setTokenizer(tokenizer);
        return newInstance;
    }

    protected IStructuredDocumentRegion parseNodes() {
        this.currentNode = null;
        this.lastNode = null;
        this.headNode = null;
        ITextRegion region = null;
        String type = null;
        while ((region = this.getNextRegion()) != null) {
            type = region.getType();
            if (type == "BLOCK_TEXT") {
                if (this.currentNode != null && this.currentNode.getLastRegion().getType() == "BLOCK_TEXT") {
                    this.currentNode.addRegion(region);
                    this.currentNode.setLength(region.getStart() + region.getLength() - this.currentNode.getStart());
                    region.adjustStart(-this.currentNode.getStart());
                    if (region instanceof ITextRegionContainer) {
                        ((ITextRegionContainer)region).setParent((ITextRegionCollection)this.currentNode);
                    }
                } else {
                    if (this.currentNode != null) {
                        if (!this.currentNode.isEnded()) {
                            this.currentNode.setLength(region.getStart() - this.currentNode.getStart());
                        }
                        this.lastNode = this.currentNode;
                    }
                    this.fireNodeParsed(this.currentNode);
                    this.currentNode = this.createStructuredDocumentRegion(type);
                    if (this.lastNode != null) {
                        this.lastNode.setNext(this.currentNode);
                    }
                    this.currentNode.setPrevious(this.lastNode);
                    this.currentNode.setStart(region.getStart());
                    this.currentNode.setLength(region.getLength());
                    this.currentNode.setEnded(true);
                    region.adjustStart(-this.currentNode.getStart());
                    this.currentNode.addRegion(region);
                    if (region instanceof ITextRegionContainer) {
                        ((ITextRegionContainer)region).setParent((ITextRegionCollection)this.currentNode);
                    }
                }
            } else if (this.currentNode != null && this.currentNode.isEnded() || type == "PHP_OPEN" || type == "TWIG_OPEN" || type == "TWIG_STMT_OPEN" || type == "TWIG_COMMENT_OPEN" || type == "XML_CONTENT" || type == "XML_CHAR_REFERENCE" || type == "XML_ENTITY_REFERENCE" || type == "XML_TAG_OPEN" || type == "XML_END_TAG_OPEN" || type == "XML_COMMENT_OPEN" || type == "XML_CDATA_OPEN" || type == "XML_DECLARATION_OPEN") {
                if (this.currentNode != null) {
                    if (!this.currentNode.isEnded()) {
                        this.currentNode.setLength(region.getStart() - this.currentNode.getStart());
                    }
                    this.lastNode = this.currentNode;
                }
                this.fireNodeParsed(this.currentNode);
                this.currentNode = this.createStructuredDocumentRegion(type);
                if (this.lastNode != null) {
                    this.lastNode.setNext(this.currentNode);
                }
                this.currentNode.setPrevious(this.lastNode);
                this.currentNode.setStart(region.getStart());
                this.currentNode.addRegion(region);
                this.currentNode.setLength(region.getStart() + region.getLength() - this.currentNode.getStart());
                region.adjustStart(-this.currentNode.getStart());
                if (region instanceof ITextRegionContainer) {
                    ((ITextRegionContainer)region).setParent((ITextRegionCollection)this.currentNode);
                }
            } else if (type == "XML_TAG_NAME" || type == "XML_TAG_ATTRIBUTE_NAME" || type == "XML_TAG_ATTRIBUTE_EQUALS" || type == "XML_TAG_ATTRIBUTE_VALUE" || type == "XML_COMMENT_TEXT" || type == "XML_PI_CONTENT" || type == "XML_DOCTYPE_INTERNAL_SUBSET" || type == "PHP_CONTENT" || type == "TWIG_CONTENT" || type == "TWIG_COMMENT") {
                this.currentNode.addRegion(region);
                this.currentNode.setLength(region.getStart() + region.getLength() - this.currentNode.getStart());
                region.adjustStart(-this.currentNode.getStart());
                if (region instanceof ITextRegionContainer) {
                    ((ITextRegionContainer)region).setParent((ITextRegionCollection)this.currentNode);
                }
            } else if (type == "PHP_CLOSE" || type == "TWIG_CLOSE" || type == "TWIG_STMT_CLOSE" || type == "TWIG_COMMENT_CLOSE" || type == "XML_PI_CLOSE" || type == "XML_TAG_CLOSE" || type == "XML_EMPTY_TAG_CLOSE" || type == "XML_COMMENT_CLOSE" || type == "XML_DECLARATION_CLOSE" || type == "XML_CDATA_CLOSE") {
                int l = region.getStart() + region.getLength() - this.currentNode.getStart();
                this.currentNode.setEnded(true);
                this.currentNode.setLength(l);
                this.currentNode.addRegion(region);
                region.adjustStart(-this.currentNode.getStart());
                if (region instanceof ITextRegionContainer) {
                    ((ITextRegionContainer)region).setParent((ITextRegionCollection)this.currentNode);
                }
            } else if (type == "WHITE_SPACE") {
                ITextRegion lastRegion = this.currentNode.getLastRegion();
                if (lastRegion instanceof ITextRegionContainer) {
                    ITextRegionContainer container = (ITextRegionContainer)lastRegion;
                    container.getRegions().add(region);
                    container.setParent((ITextRegionCollection)this.currentNode);
                    if (region instanceof ITextRegionContainer) {
                        ((ITextRegionContainer)region).setParent((ITextRegionCollection)this.currentNode);
                    }
                    region.adjustStart(container.getLength() - region.getStart());
                }
                this.currentNode.getLastRegion().adjustLength(region.getLength());
                this.currentNode.adjustLength(region.getLength());
            } else if (type == "UNDEFINED" && this.currentNode != null) {
                if (this.currentNode.getLastRegion() != null && this.currentNode.getLastRegion().getType() == "UNDEFINED") {
                    this.currentNode.getLastRegion().adjustLength(region.getLength());
                    this.currentNode.adjustLength(region.getLength());
                } else {
                    this.currentNode.addRegion(region);
                    this.currentNode.setLength(region.getStart() + region.getLength() - this.currentNode.getStart());
                    region.adjustStart(-this.currentNode.getStart());
                }
            } else {
                if (this.currentNode == null) {
                    this.currentNode = this.createStructuredDocumentRegion(type);
                    this.currentNode.setStart(region.getStart());
                }
                this.currentNode.addRegion(region);
                this.currentNode.setLength(region.getStart() + region.getLength() - this.currentNode.getStart());
                region.adjustStart(-this.currentNode.getStart());
                if (region instanceof ITextRegionContainer) {
                    ((ITextRegionContainer)region).setParent((ITextRegionCollection)this.currentNode);
                }
            }
            if (type == "XML_CONTENT" || type == "XML_CHAR_REFERENCE" || type == "XML_ENTITY_REFERENCE" || type == "PHP_CLOSE" || type == "TWIG_CLOSE" || type == "TWIG_STMT_CLOSE" || type == "TWIG_COMMENT_CLOSE") {
                this.currentNode.setEnded(true);
            }
            if (this.headNode != null || this.currentNode == null) continue;
            this.headNode = this.currentNode;
        }
        if (this.currentNode != null) {
            this.fireNodeParsed(this.currentNode);
            this.currentNode.setPrevious(this.lastNode);
        }
        this.primReset();
        return this.headNode;
    }

    public void reset(Reader reader, int position) {
        super.reset(reader, position);
    }
}

