/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.documentModel.parser.regions;

import com.dubture.twig.core.documentModel.parser.AbstractTwigLexer;
import com.dubture.twig.core.documentModel.parser.TwigLexer;
import com.dubture.twig.core.documentModel.parser.regions.ITwigScriptRegion;
import com.dubture.twig.core.documentModel.parser.regions.TwigTokenContainer;
import java.io.IOException;
import java.io.Reader;
import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.parser.Scanner;
import org.eclipse.wst.sse.core.internal.parser.ForeignRegion;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.Logger;

public class TwigScriptRegion
extends ForeignRegion
implements ITwigScriptRegion {
    private static final String TWIG_SCRIPT = "Twig Script";
    private int ST_TWIG_CONTENT = -1;
    private IProject project;
    private boolean isFullReparsed;
    private final TwigTokenContainer tokensContainer = new TwigTokenContainer();

    public TwigScriptRegion(String newContext, int startOffset, IProject project, AbstractTwigLexer twigLexer, String lexerState) {
        super(newContext, startOffset, 0, 0, TWIG_SCRIPT);
        this.project = project;
        try {
            this.ST_TWIG_CONTENT = twigLexer.getClass().getField(lexerState).getInt(twigLexer);
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        this.completeReparse(twigLexer);
    }

    public boolean isFullReparsed() {
        return this.isFullReparsed;
    }

    @Override
    public String getPartition(int offset) throws BadLocationException {
        return this.tokensContainer.getPartitionType(offset);
    }

    private boolean startQuoted(String text) {
        int length = text.length();
        if (length == 0) {
            return false;
        }
        boolean isOdd = false;
        int index = 0;
        while (index < length) {
            char charAt = text.charAt(index);
            if (charAt == '\"' || charAt == '\'') {
                isOdd = !isOdd;
            }
            ++index;
        }
        return isOdd;
    }

    private TwigLexer getTwigLexer(Reader stream, Scanner.LexerState startState) {
        TwigLexer lexer = new TwigLexer(stream);
        lexer.initialize(this.ST_TWIG_CONTENT);
        lexer.setPatterns(this.project);
        if (startState != null) {
            startState.restoreState((Scanner)lexer);
        }
        return lexer;
    }

    public StructuredDocumentEvent updateRegion(Object requester, IStructuredDocumentRegion flatnode, String changes, int requestStart, int lengthToReplace) {
        int end;
        int size;
        TwigTokenContainer newContainer;
        ITextRegion tokenEnd;
        ITextRegion tokenStart;
        block20: {
            Scanner.LexerState state;
            Scanner.LexerState endState;
            int length;
            block19: {
                int offset;
                block18: {
                    block17: {
                        this.isFullReparsed = true;
                        offset = requestStart - flatnode.getStartOffset() - this.getStart();
                        if (offset >= 4) break block17;
                        return null;
                    }
                    String deletedText = lengthToReplace == 0 ? "" : flatnode.getParentDocument().get(requestStart, lengthToReplace);
                    length = changes.length();
                    if (!this.startQuoted(deletedText) && !this.startQuoted(changes)) break block18;
                    return null;
                }
                tokenStart = this.tokensContainer.getToken(offset == 0 ? 0 : offset - 1);
                tokenEnd = this.tokensContainer.getToken(offset + lengthToReplace);
                while ("UNKNOWN_TOKEN".equals(tokenStart.getType()) && tokenStart.getStart() > 0) {
                    tokenStart = this.tokensContainer.getToken(tokenStart.getStart() - 1);
                }
                while ("UNKNOWN_TOKEN".equals(tokenEnd.getType()) && this.tokensContainer.getLastToken() != tokenEnd) {
                    tokenEnd = this.tokensContainer.getToken(tokenEnd.getEnd() + 1);
                }
                boolean shouldDeprecatedKeyword = false;
                int previousIndex = this.tokensContainer.twigTokens.indexOf(tokenStart) - 1;
                if (previousIndex >= 0) {
                    ITextRegion previousRegion = this.tokensContainer.twigTokens.get(previousIndex);
                    if (tokenStart.getType().equals("TWIG_COMMENT") && tokenStart.getLength() == 1 && previousRegion.getType().equals("TWIG_COMMENT_OPEN")) {
                        requestStart = previousRegion.getStart();
                    }
                }
                int newTokenOffset = tokenStart.getStart();
                Scanner.LexerState startState = this.tokensContainer.getState(newTokenOffset);
                endState = this.tokensContainer.getState(tokenEnd.getEnd() + 1);
                newContainer = new TwigTokenContainer();
                TwigLexer twigLexer = this.getTwigLexer(new DocumentReader(flatnode, changes, requestStart, lengthToReplace, newTokenOffset), startState);
                state = startState;
                try {
                    int yylength;
                    String yylex = twigLexer.getNextToken();
                    if (shouldDeprecatedKeyword && TwigTokenContainer.isKeyword(yylex)) {
                        yylex = "PHP_STRING";
                    }
                    int toOffset = offset + length;
                    while (yylex != null && newTokenOffset <= toOffset && yylex != "TWIG_COMMENT_CLOSE" && yylex != "TWIG_CLOSETAG" && yylex != "TWIG_STMT_CLOSE") {
                        yylength = twigLexer.getLength();
                        newContainer.addLast(yylex, newTokenOffset, yylength, yylength, state);
                        newTokenOffset += yylength;
                        state = twigLexer.createLexicalStateMemento();
                        yylex = twigLexer.getNextToken();
                    }
                    if (yylex == "WHITESPACE") {
                        yylength = twigLexer.getLength();
                        newContainer.adjustWhitespace(yylex, newTokenOffset, yylength, yylength, state);
                    }
                }
                catch (IOException e) {
                    Logger.logException((Throwable)e);
                }
                if (!newContainer.isEmpty()) break block19;
                return null;
            }
            size = length - lengthToReplace;
            end = newContainer.getLastToken().getEnd();
            if (state.equals(endState) && tokenEnd.getEnd() + size == end) break block20;
            return null;
        }
        try {
            ListIterator<ITextRegion> oldIterator = this.tokensContainer.removeTokensSubList(tokenStart, tokenEnd);
            ITextRegion[] newTokens = newContainer.getTwigTokens();
            int i = 0;
            while (i < newTokens.length) {
                oldIterator.add(newTokens[i]);
                ++i;
            }
            while (oldIterator.hasNext()) {
                ITextRegion adjust = oldIterator.next();
                adjust.adjustStart(size);
            }
            this.tokensContainer.updateStateChanges(newContainer, tokenStart.getStart(), end);
            this.isFullReparsed = false;
            return super.updateRegion(requester, flatnode, changes, requestStart, lengthToReplace);
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log((Throwable)e);
            return null;
        }
    }

    public int getTokenCount() {
        return this.tokensContainer.size();
    }

    private void completeReparse(AbstractTwigLexer twigLexer) {
        this.setTwigtokens(twigLexer);
    }

    private void setTwigtokens(AbstractTwigLexer lexer) {
        this.setLength(0);
        this.setTextLength(0);
        this.isFullReparsed = true;
        assert (lexer != null);
        int start = 0;
        this.tokensContainer.getModelForCreation();
        this.tokensContainer.reset();
        try {
            try {
                Scanner.LexerState state = lexer.createLexicalStateMemento();
                String yylex = lexer.getNextToken();
                int yylength = 0;
                while (yylex != null && yylex != "TWIG_COMMENT_CLOSE" && yylex != "TWIG_CLOSETAG" && yylex != "TWIG_STMT_CLOSE") {
                    yylength = lexer.getLength();
                    this.tokensContainer.addLast(yylex, start, yylength, yylength, state);
                    start += yylength;
                    state = lexer.createLexicalStateMemento();
                    yylex = lexer.getNextToken();
                }
                this.adjustLength(start);
                this.adjustTextLength(start);
            }
            catch (Exception e) {
                Logger.logException((Throwable)e);
                this.tokensContainer.releaseModelFromCreation();
            }
        }
        finally {
            this.tokensContainer.releaseModelFromCreation();
        }
    }

    @Override
    public ITextRegion getTwigToken(int offset) throws BadLocationException {
        return this.tokensContainer.getToken(offset);
    }

    @Override
    public final ITextRegion[] getTwigTokens(int offset, int length) throws BadLocationException {
        return this.tokensContainer.getTokens(offset, length);
    }

    @Override
    public final String getTwigTokenType(int offset) throws BadLocationException {
        ITextRegion tokenForOffset = this.getTwigToken(offset);
        return tokenForOffset == null ? null : tokenForOffset.getType();
    }

    public static class BlockDocumentReader
    extends Reader {
        private static final String BAD_LOCATION_ERROR = "Bad location error ";
        private final IDocument parent;
        private int startPhpRegion;
        private final int endPhpRegion;

        public BlockDocumentReader(IDocument parent, int startPhpRegion, int length) {
            this.parent = parent;
            this.startPhpRegion = startPhpRegion;
            this.endPhpRegion = startPhpRegion + length;
        }

        @Override
        public int read() throws IOException {
            try {
                return this.startPhpRegion < this.endPhpRegion ? (int)this.parent.getChar(this.startPhpRegion++) : -1;
            }
            catch (BadLocationException e) {
                throw new IOException(BAD_LOCATION_ERROR + this.startPhpRegion);
            }
        }

        @Override
        public int read(char[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[off] = (char)c;
            int i = 1;
            try {
                while (i < len) {
                    c = this.read();
                    if (c != -1) {
                        if (b != null) {
                            b[off + i] = (char)c;
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return i;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class DocumentReader
    extends Reader {
        private static final String BAD_LOCATION_ERROR = "Bad location error ";
        private final IStructuredDocument parent;
        private final int startPhpRegion;
        private final int endPhpRegion;
        private final int changeLength;
        private final String change;
        private final int requestStart;
        private final int lengthToReplace;
        private int index;
        private int internalIndex = 0;

        public DocumentReader(IStructuredDocumentRegion flatnode, String change, int requestStart, int lengthToReplace, int newTokenOffset) {
            this.parent = flatnode.getParentDocument();
            this.startPhpRegion = flatnode.getStart() + TwigScriptRegion.this.getStart();
            this.endPhpRegion = this.startPhpRegion + TwigScriptRegion.this.getLength();
            this.changeLength = change.length();
            this.index = this.startPhpRegion + newTokenOffset;
            this.change = change;
            this.requestStart = requestStart;
            this.lengthToReplace = lengthToReplace;
        }

        @Override
        public int read() throws IOException {
            try {
                if (this.index < this.requestStart) {
                    return this.parent.getChar(this.index++);
                }
                if (this.internalIndex < this.changeLength) {
                    return this.change.charAt(this.internalIndex++);
                }
                if (this.index < this.requestStart + this.lengthToReplace) {
                    this.index = this.requestStart + this.lengthToReplace;
                }
                return this.index < this.endPhpRegion ? (int)this.parent.getChar(this.index++) : -1;
            }
            catch (BadLocationException e) {
                throw new IOException(BAD_LOCATION_ERROR);
            }
        }

        @Override
        public int read(char[] b, int off, int len) throws IOException {
            int n = len = len > 80 ? 80 : len;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[off] = (char)c;
            int i = 1;
            try {
                while (i < len) {
                    c = this.read();
                    if (c != -1) {
                        if (b != null) {
                            b[off + i] = (char)c;
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return i;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

