/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.documentModel.parser.regions;

import com.dubture.twig.core.documentModel.parser.partitioner.TwigPartitionTypes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.documentModel.parser.Scanner;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class TwigTokenContainer {
    protected final LinkedList<ITextRegion> twigTokens = new LinkedList();
    protected final LinkedList<LexerStateChange> lexerStateChanges = new LinkedList();
    protected ListIterator<ITextRegion> tokensIterator = null;

    public void getModelForCreation() {
        this.tokensIterator = null;
    }

    public int size() {
        return this.twigTokens.size();
    }

    public boolean isEmpty() {
        return this.twigTokens.isEmpty();
    }

    public ITextRegion[] getTwigTokens() {
        return this.twigTokens.toArray(new ITextRegion[this.twigTokens.size()]);
    }

    protected final synchronized ListIterator<LexerStateChange> removeOldChanges(int fromOffset, int toOffset) {
        ListIterator iterator = (ListIterator)this.lexerStateChanges.iterator();
        LexerStateChange element = (LexerStateChange)iterator.next();
        while (element.getOffset() <= toOffset) {
            if (element.getOffset() > fromOffset && element.getOffset() <= toOffset) {
                iterator.remove();
            }
            if (!iterator.hasNext()) {
                return iterator;
            }
            element = (LexerStateChange)iterator.next();
        }
        return iterator;
    }

    private void setIterator(ListIterator<LexerStateChange> oldIterator, int fromOffset, int toOffset) {
        if (oldIterator.nextIndex() == 1) {
            return;
        }
        oldIterator.previous();
        LexerStateChange next = oldIterator.next();
        int offset = next.getOffset();
        if (offset > fromOffset) {
            oldIterator.previous();
        }
    }

    public void updateStateChanges(TwigTokenContainer newContainer, int fromOffset, int toOffset) {
        if (newContainer.lexerStateChanges.size() < 2) {
            return;
        }
        ListIterator<LexerStateChange> oldIterator = this.removeOldChanges(fromOffset, toOffset);
        Iterator newIterator = newContainer.lexerStateChanges.iterator();
        newIterator.next();
        this.setIterator(oldIterator, fromOffset, toOffset);
        while (newIterator.hasNext()) {
            oldIterator.add((LexerStateChange)newIterator.next());
        }
    }

    public synchronized ListIterator<ITextRegion> removeTokensSubList(ITextRegion tokenStart, ITextRegion tokenEnd) {
        ITextRegion region;
        block6: {
            assert (tokenStart != null);
            region = null;
            try {
                region = this.getToken(tokenStart.getStart());
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        assert (region == tokenStart);
        this.tokensIterator.remove();
        if (tokenStart != tokenEnd) {
            do {
                region = this.tokensIterator.next();
                this.tokensIterator.remove();
            } while (this.tokensIterator.hasNext() && region != tokenEnd);
        }
        return this.tokensIterator;
    }

    public void adjustWhitespace(String yylex, int start, int yylengthLength, int yylength, Object lexerState) {
        assert ((this.twigTokens.size() == 0 || this.getLastToken().getEnd() == start) && this.tokensIterator == null);
        if (this.lexerStateChanges.size() != 0 && this.getLastChange().state.equals(lexerState)) {
            ITextRegion last = this.twigTokens.getLast();
            last.adjustLength(yylength);
        }
    }

    public void reset() {
        this.twigTokens.clear();
        this.lexerStateChanges.clear();
    }

    public static boolean isKeyword(String yylex) {
        return false;
    }

    protected final ITextRegion getLastToken() {
        return this.twigTokens.getLast();
    }

    protected LexerStateChange getLastChange() {
        return this.lexerStateChanges.getLast();
    }

    public synchronized void addLast(String yylex, int start, int yylengthLength, int yylength, Object lexerState) {
        assert ((this.twigTokens.size() == 0 || this.getLastToken().getEnd() == start) && this.tokensIterator == null);
        if (this.lexerStateChanges.size() == 0 || !this.getLastChange().state.equals(lexerState)) {
            int textLength = "WHITESPACE".equals(yylex) ? 0 : yylengthLength;
            ContextRegion contextRegion = new ContextRegion(yylex, start, textLength, yylength);
            this.twigTokens.addLast((ITextRegion)contextRegion);
            this.lexerStateChanges.addLast(new LexerStateChange((Scanner.LexerState)lexerState, (ITextRegion)contextRegion));
            return;
        }
        assert (this.twigTokens.size() > 0);
        if (yylex == "WHITESPACE") {
            ITextRegion last = this.twigTokens.getLast();
            last.adjustLength(yylength);
        } else {
            ContextRegion contextRegion = new ContextRegion(yylex, start, yylengthLength, yylength);
            this.twigTokens.addLast((ITextRegion)contextRegion);
        }
    }

    public void releaseModelFromCreation() {
        this.tokensIterator = this.twigTokens.listIterator();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized ITextRegion getToken(int offset) throws BadLocationException {
        block8: {
            if (!TwigTokenContainer.$assertionsDisabled && this.tokensIterator == null) {
                throw new AssertionError();
            }
            if (this.twigTokens.isEmpty()) {
                return null;
            }
            this.checkBadLocation(offset);
            oldResult = result = this.tokensIterator.hasNext() != false ? this.tokensIterator.next() : this.tokensIterator.previous();
            if (this.isInside(result, offset)) {
                return result;
            }
            if (result == null || offset < result.getEnd()) ** GOTO lbl21
            while (this.tokensIterator.hasNext() && !this.isInside(result, offset)) {
                if (result == null) {
                    return oldResult;
                }
                oldResult = result;
                result = this.tokensIterator.next();
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                if (result == null) {
                    return oldResult;
                }
                oldResult = result;
                result = this.tokensIterator.previous();
lbl21:
                // 2 sources

                ** while (this.tokensIterator.hasPrevious() && !this.isInside((ITextRegion)result, (int)offset))
            }
lbl22:
            // 1 sources

            if (this.tokensIterator.hasNext()) {
                this.tokensIterator.next();
            }
        }
        return result;
    }

    public Scanner.LexerState getState(int offset) throws BadLocationException {
        Iterator iter = this.lexerStateChanges.iterator();
        assert (iter.hasNext());
        LexerStateChange element = (LexerStateChange)iter.next();
        Scanner.LexerState lastState = null;
        while (offset >= element.getOffset()) {
            lastState = element.state;
            if (!iter.hasNext()) {
                return lastState;
            }
            element = (LexerStateChange)iter.next();
        }
        return lastState;
    }

    private final boolean isInside(ITextRegion region, int offset) {
        return region != null && region.getStart() <= offset && offset < region.getEnd();
    }

    protected final void checkBadLocation(int offset) throws BadLocationException {
        ITextRegion lastRegion = this.getLastToken();
        if (offset < 0 || lastRegion.getEnd() < offset) {
            throw new BadLocationException("offset " + offset + " is out of [0, " + lastRegion.getEnd() + "]");
        }
    }

    public synchronized ITextRegion[] getTokens(int offset, int length) throws BadLocationException {
        assert (length >= 0);
        ArrayList<ITextRegion> result = new ArrayList<ITextRegion>();
        ITextRegion token = this.getToken(offset);
        if (token != null) {
            result.add(token);
        }
        while (this.tokensIterator.hasNext() && token != null && token.getEnd() <= offset + length) {
            token = this.tokensIterator.next();
            result.add(token);
        }
        return result.toArray(new ITextRegion[result.size()]);
    }

    public String getPartitionType(int offset) throws BadLocationException {
        ITextRegion token = this.getToken(offset);
        assert (token != null);
        String type = token.getType();
        if (TwigPartitionTypes.isTwigQuotesState(type)) {
            return "com.dubture.twig.TWIG_QUOTED_STRING";
        }
        return "com.dubture.twig.TWIG_DEFAULT";
    }

    protected static final class LexerStateChange {
        public final Scanner.LexerState state;
        public final ITextRegion firstRegion;

        public LexerStateChange(Scanner.LexerState state, ITextRegion firstRegion) {
            assert (firstRegion != null && state != null);
            this.state = state;
            this.firstRegion = firstRegion;
        }

        public final int getOffset() {
            return this.firstRegion.getStart();
        }

        public int hashCode() {
            return 31 + (this.state == null ? 0 : this.state.hashCode());
        }

        public boolean equals(Object obj) {
            assert (this.state != null && obj.getClass() == Scanner.LexerState.class);
            if (this.state == obj) {
                return true;
            }
            return this.state.equals((Scanner.LexerState)obj);
        }

        public final String toString() {
            return "[" + this.getOffset() + "] - " + this.state.getTopState();
        }
    }
}

