/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.format;

import com.dubture.twig.core.TwigCorePlugin;
import com.dubture.twig.core.documentModel.parser.partitioner.TwigPartitionTypes;
import com.dubture.twig.core.documentModel.parser.partitioner.TwigStructuredTextPartitioner;
import com.dubture.twig.core.documentModel.parser.regions.ITwigScriptRegion;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class FormatterUtils {
    private static TwigStructuredTextPartitioner partitioner = new TwigStructuredTextPartitioner();
    private static StringBuffer helpBuffer = new StringBuffer(50);

    public static String getRegionType(IStructuredDocument document, int offset) {
        IStructuredDocumentRegion sdRegion2;
        block8: {
            sdRegion2 = document.getRegionAtCharacterOffset(offset);
            if (sdRegion2 != null) break block8;
            return null;
        }
        try {
            ITextRegion tRegion = sdRegion2.getRegionAtCharacterOffset(offset);
            if (tRegion == null && offset == document.getLength()) {
                tRegion = sdRegion2.getRegionAtCharacterOffset(--offset);
            }
            if (tRegion.getType().equals("TWIG_CLOSE") || tRegion.getType().equals("TWIG_STMT_CLOSE")) {
                tRegion = sdRegion2.getRegionAtCharacterOffset(offset - 1);
            }
            int regionStart = sdRegion2.getStartOffset(tRegion);
            if (tRegion != null && tRegion instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)tRegion;
                tRegion = container.getRegionAtCharacterOffset(offset);
                regionStart += tRegion.getStart();
            }
            if (tRegion != null && tRegion instanceof ITwigScriptRegion) {
                ITwigScriptRegion scriptRegion = (ITwigScriptRegion)tRegion;
                int regionOffset = offset - regionStart;
                ITextRegion innerRegion = scriptRegion.getTwigToken(regionOffset);
                return innerRegion.getType();
            }
        }
        catch (BadLocationException sdRegion2) {
        }
        catch (Exception e1) {
            TwigCorePlugin.log(e1);
        }
        return null;
    }

    public static String getPartitionType(IStructuredDocument document, int offset, boolean perferOpenPartitions) {
        block10: {
            String partition;
            block11: {
                IStructuredDocumentRegion sdRegion;
                block9: {
                    sdRegion = document.getRegionAtCharacterOffset(offset);
                    if (sdRegion != null) break block9;
                    return null;
                }
                ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
                if (tRegion == null && offset == document.getLength()) {
                    tRegion = sdRegion.getRegionAtCharacterOffset(--offset);
                }
                if (tRegion.getType().equals("TWIG_CLOSE") || tRegion.getType().equals("TWIG_STMT_CLOSE")) {
                    tRegion = sdRegion.getRegionAtCharacterOffset(offset - 1);
                }
                int regionStart = sdRegion.getStartOffset(tRegion);
                if (tRegion != null && tRegion instanceof ITextRegionContainer) {
                    ITextRegionContainer container = (ITextRegionContainer)tRegion;
                    tRegion = container.getRegionAtCharacterOffset(offset);
                    regionStart += tRegion.getStart();
                }
                if (tRegion == null || !(tRegion instanceof ITwigScriptRegion)) break block10;
                ITwigScriptRegion scriptRegion = (ITwigScriptRegion)tRegion;
                int regionOffset = offset - regionStart;
                ITextRegion innerRegion = scriptRegion.getTwigToken(regionOffset);
                partition = scriptRegion.getPartition(regionOffset);
                if (offset - (sdRegion.getStart() + regionStart + innerRegion.getStart()) != 0) break block11;
                String regionType = innerRegion.getType();
                if (TwigPartitionTypes.isTwigCommentState(regionType) || regionType != "TWIG_COMMENT_OPEN") {
                    return partition;
                }
                return "com.dubture.twig.TWIG_DEFAULT";
            }
            try {
                return partition;
            }
            catch (BadLocationException sdRegion) {
            }
            catch (Exception e1) {
                TwigCorePlugin.log(e1);
            }
        }
        partitioner.connect((IDocument)document);
        return partitioner.getContentType(offset, perferOpenPartitions);
    }

    public static String getPartitionType(IStructuredDocument document, int offset) {
        return FormatterUtils.getPartitionType(document, offset, false);
    }

    public static String getLineBlanks(IStructuredDocument document, IRegion lineInfo) throws BadLocationException {
        helpBuffer.setLength(0);
        int startOffset = lineInfo.getOffset();
        int length = lineInfo.getLength();
        char[] line = document.get(startOffset, length).toCharArray();
        int i = 0;
        while (i < line.length) {
            char c = line[i];
            if (!Character.isWhitespace(c)) break;
            helpBuffer.append(c);
            ++i;
        }
        return helpBuffer.toString();
    }

    public static IStructuredDocumentRegion getLastTwigStructuredDocumentRegion(IStructuredDocumentRegion currentStructuredDocumentRegion) {
        assert (currentStructuredDocumentRegion != null);
        currentStructuredDocumentRegion = currentStructuredDocumentRegion.getPrevious();
        while (currentStructuredDocumentRegion != null && currentStructuredDocumentRegion.getType() != "TWIG_CONTENT") {
            currentStructuredDocumentRegion = currentStructuredDocumentRegion.getPrevious();
        }
        return currentStructuredDocumentRegion;
    }
}

