/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.format.htmlFormatters;

import com.dubture.twig.core.documentModel.dom.ElementImplForTwig;
import com.dubture.twig.core.format.TwigFormatter;
import com.dubture.twig.core.format.htmlFormatters.EmbeddedCSSFormatterNoTwig;
import com.dubture.twig.core.format.htmlFormatters.HTMLFormatterNoTwig;
import com.dubture.twig.core.format.htmlFormatters.HTMLTextFormatterNoTwig;
import com.dubture.twig.core.format.htmlFormatters.HtmlElementFormatterNoTwig;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.w3c.dom.Node;

public class HTMLFormatterNoTwigFactory {
    private static HTMLFormatterNoTwigFactory fInstance = null;
    public int start;
    public int length;

    public static synchronized HTMLFormatterNoTwigFactory getInstance() {
        if (fInstance == null) {
            fInstance = new HTMLFormatterNoTwigFactory();
        }
        return fInstance;
    }

    public IStructuredFormatter createFormatter(Node node, IStructuredFormatPreferences formatPreferences) {
        Object formatter = null;
        switch (node.getNodeType()) {
            case 1: {
                if (node instanceof ElementImplForTwig && ((ElementImplForTwig)((Object)node)).isTwigTag()) {
                    formatter = new TwigFormatter(this.start, this.length);
                    break;
                }
                formatter = new HtmlElementFormatterNoTwig();
                break;
            }
            case 3: {
                if (this.isEmbeddedCSS(node)) {
                    formatter = new EmbeddedCSSFormatterNoTwig();
                    break;
                }
                formatter = new HTMLTextFormatterNoTwig();
                break;
            }
            default: {
                formatter = new HTMLFormatterNoTwig();
            }
        }
        formatter.setFormatPreferences(formatPreferences);
        return formatter;
    }

    private boolean isEmbeddedCSS(Node node) {
        if (node == null) {
            return false;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        if (parent.getNodeType() != 1) {
            return false;
        }
        String name = parent.getNodeName();
        if (name == null) {
            return false;
        }
        return name.equalsIgnoreCase("STYLE");
    }
}

