/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.format.htmlFormatters;

import com.dubture.twig.core.format.htmlFormatters.HTMLFormatterNoTwig;
import com.dubture.twig.core.format.htmlFormatters.HTMLFormatterNoTwigFactory;
import org.eclipse.wst.html.core.internal.format.HTMLTextFormatter;
import org.eclipse.wst.html.core.internal.provisional.HTMLFormatContraints;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class HTMLTextFormatterNoTwig
extends HTMLTextFormatter {
    protected void formatChildNodes(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        if (!node.hasChildNodes()) {
            return;
        }
        node.normalize();
        boolean indent = false;
        if (contraints != null) {
            indent = contraints.getFormatWithSiblingIndent();
            contraints.setFormatWithSiblingIndent(false);
        }
        boolean insertBreak = true;
        IDOMNode child = (IDOMNode)node.getFirstChild();
        while (child != null) {
            IStructuredFormatter formatter;
            if (child.getParentNode() != node) break;
            IDOMNode next = (IDOMNode)child.getNextSibling();
            if (insertBreak && this.canInsertBreakBefore((Node)child)) {
                this.insertBreakBefore(child, contraints);
            }
            if ((formatter = HTMLFormatterNoTwigFactory.getInstance().createFormatter((Node)child, this.getFormatPreferences())) != null) {
                if (formatter instanceof HTMLFormatterNoTwig) {
                    HTMLFormatterNoTwig htmlFormatter = (HTMLFormatterNoTwig)formatter;
                    htmlFormatter.formatNode(child, contraints);
                } else {
                    formatter.format((Node)child);
                }
            }
            if (this.canInsertBreakAfter((Node)child)) {
                this.insertBreakAfter(child, contraints);
                insertBreak = false;
            } else {
                insertBreak = true;
            }
            child = next;
        }
        if (contraints != null) {
            contraints.setFormatWithSiblingIndent(indent);
        }
    }

    protected void insertBreakAfter(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 3) {
            return;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        Node next = node.getNextSibling();
        String spaces = null;
        if (next == null) {
            spaces = this.getBreakSpaces(parent);
        } else {
            if (next.getNodeType() == 3) {
                if (contraints != null && contraints.getFormatWithSiblingIndent()) {
                    IDOMNode text = (IDOMNode)next;
                    IStructuredFormatter formatter = HTMLFormatterNoTwigFactory.getInstance().createFormatter((Node)text, this.getFormatPreferences());
                    if (formatter instanceof HTMLTextFormatterNoTwig) {
                        HTMLTextFormatterNoTwig textFormatter = (HTMLTextFormatterNoTwig)formatter;
                        textFormatter.formatText(text, contraints, HTMLTextFormatter.FORMAT_HEAD);
                    }
                }
                return;
            }
            spaces = this.getBreakSpaces((Node)node);
        }
        if (spaces == null || spaces.length() == 0) {
            return;
        }
        this.replaceSource(node.getModel(), node.getEndOffset(), 0, spaces);
        this.setWidth(contraints, spaces);
    }

    protected void insertBreakBefore(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 3) {
            return;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        Node prev = node.getPreviousSibling();
        String spaces = null;
        if (prev != null && prev.getNodeType() == 3) {
            if (contraints != null && contraints.getFormatWithSiblingIndent()) {
                IDOMNode text = (IDOMNode)prev;
                IStructuredFormatter formatter = HTMLFormatterNoTwigFactory.getInstance().createFormatter((Node)text, this.getFormatPreferences());
                if (formatter instanceof HTMLTextFormatterNoTwig) {
                    HTMLTextFormatterNoTwig textFormatter = (HTMLTextFormatterNoTwig)formatter;
                    textFormatter.formatText(text, contraints, HTMLTextFormatter.FORMAT_TAIL);
                    if (node.hasChildNodes()) {
                        this.formatChildNodes(node, contraints);
                    } else {
                        String source;
                        IStructuredDocumentRegion flatNode = node.getStartStructuredDocumentRegion();
                        if (flatNode != null && (source = flatNode.getText()) != null && source.length() > 0) {
                            this.setWidth(contraints, source);
                        }
                    }
                }
            }
            return;
        }
        spaces = this.getBreakSpaces((Node)node);
        if (spaces == null || spaces.length() == 0) {
            return;
        }
        this.replaceSource(node.getModel(), node.getStartOffset(), 0, spaces);
        this.setWidth(contraints, spaces);
    }

    public void formatText(IDOMNode node, HTMLFormatContraints contraints, int mode) {
        super.formatText(node, contraints, mode);
    }
}

