/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.index;

import com.dubture.twig.core.log.Logger;
import com.dubture.twig.core.parser.ast.node.BlockName;
import com.dubture.twig.core.parser.ast.node.BlockStatement;
import com.dubture.twig.core.parser.ast.node.StringLiteral;
import com.dubture.twig.core.parser.ast.node.Variable;
import com.dubture.twig.core.parser.ast.visitor.TwigASTVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.index2.IIndexingRequestor;

public class TwigIndexingVisitor
extends TwigASTVisitor {
    private IIndexingRequestor requestor;
    private ISourceModule module;
    BlockStatement currentTag = null;
    BlockStatement extendsTag = null;
    BlockStatement blockTag = null;

    public TwigIndexingVisitor(IIndexingRequestor requestor, ISourceModule module) {
        this.requestor = requestor;
        this.module = module;
    }

    @Override
    public boolean visit(BlockName s) throws Exception {
        if (this.currentTag != null) {
            if (this.currentTag.isBlock()) {
                this.blockTag = this.currentTag;
            } else if (this.currentTag.isExtends()) {
                this.extendsTag = this.currentTag;
            }
        }
        return false;
    }

    @Override
    public boolean visit(BlockStatement block) throws Exception {
        this.currentTag = block;
        return true;
    }

    @Override
    public boolean endvisit(BlockStatement block) throws Exception {
        this.currentTag = null;
        this.extendsTag = null;
        this.blockTag = null;
        return true;
    }

    @Override
    public boolean visit(Variable s) throws Exception {
        if (this.blockTag != null) {
            Logger.debugMSG("Indexing block reference " + s.getValue() + " in " + this.module.getElementName() + " / " + this.module.getScriptProject().getElementName());
            IIndexingRequestor.ReferenceInfo info = new IIndexingRequestor.ReferenceInfo(805, s.sourceStart(), s.sourceEnd() - s.sourceStart(), s.getValue(), null, null);
            this.requestor.addReference(info);
        }
        return false;
    }

    @Override
    public boolean visit(StringLiteral s) throws Exception {
        if (this.extendsTag != null) {
            Logger.debugMSG("Indexing extends reference " + s.getValue());
            IIndexingRequestor.ReferenceInfo info = new IIndexingRequestor.ReferenceInfo(806, s.sourceStart(), s.sourceEnd() - s.sourceStart(), s.getValue(), null, null);
            this.requestor.addReference(info);
        }
        return false;
    }
}

