/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.index;

import com.dubture.twig.core.index.TwigIndexingVisitor;
import com.dubture.twig.core.log.Logger;
import com.dubture.twig.core.util.TwigModelUtils;
import com.dubture.twig.internal.core.model.Filter;
import com.dubture.twig.internal.core.model.Function;
import com.dubture.twig.internal.core.model.Tag;
import com.dubture.twig.internal.core.model.Test;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.index2.IIndexingRequestor;
import org.eclipse.php.core.compiler.ast.nodes.ArrayCreation;
import org.eclipse.php.core.compiler.ast.nodes.ArrayElement;
import org.eclipse.php.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.compiler.ast.nodes.ExpressionStatement;
import org.eclipse.php.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.ReturnStatement;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.core.index.PHPIndexingVisitorExtension;
import org.json.simple.JSONObject;

public class TwigIndexingVisitorExtension
extends PHPIndexingVisitorExtension {
    protected boolean inTwigExtension;
    protected boolean inTokenParser;
    protected boolean inTagParseMethod;
    protected ClassDeclaration currentClass;
    protected Tag tag;
    protected List<MethodDeclaration> methods = new ArrayList<MethodDeclaration>();
    protected List<Function> functions = new ArrayList<Function>();
    protected List<Filter> filters = new ArrayList<Filter>();
    protected List<Test> tests = new ArrayList<Test>();

    public void setSourceModule(ISourceModule module) {
        super.setSourceModule(module);
    }

    public boolean visit(MethodDeclaration s) throws Exception {
        IProject project = this.sourceModule.getScriptProject().getProject();
        if (project == null || !project.isAccessible() || !project.hasNature("com.dubture.twig.core.TwigNature")) {
            return false;
        }
        if (!this.methods.contains(s)) {
            this.methods.add(s);
        }
        if (s instanceof PHPMethodDeclaration) {
            PHPMethodDeclaration phpMethod = (PHPMethodDeclaration)s;
            if (this.inTwigExtension && phpMethod.getName().equals("getFilters")) {
                phpMethod.traverse((ASTVisitor)new PHPASTVisitor(){

                    public boolean visit(ArrayElement s) throws Exception {
                        Expression value;
                        Expression key = s.getKey();
                        if (key == null | (value = s.getValue()) == null) {
                            return false;
                        }
                        if (key.getClass() == Scalar.class && value.getClass() == ClassInstanceCreation.class) {
                            Filter filter;
                            String elemName;
                            Scalar internal;
                            Scalar name = (Scalar)key;
                            ClassInstanceCreation filterClass = (ClassInstanceCreation)value;
                            CallArgumentsList ctorParams = filterClass.getCtorParams();
                            Object child = ctorParams.getChilds().get(0);
                            if (child instanceof VariableReference && ((VariableReference)child).getName().equals("$this") && filterClass.getClassName().toString().equals("Twig_Filter_Method") && ctorParams.getChilds().size() > 2 && ctorParams.getChilds().get(1) instanceof Scalar) {
                                internal = (Scalar)ctorParams.getChilds().get(1);
                                elemName = name.getValue().replaceAll("['\"]", "");
                                filter = new Filter(elemName);
                                filter.setInternalFunction(internal.getValue().replaceAll("['\"]", ""));
                                filter.setPhpClass(TwigIndexingVisitorExtension.this.currentClass.getName());
                                TwigIndexingVisitorExtension.this.filters.add(filter);
                            }
                            if (!(child instanceof Scalar)) {
                                return true;
                            }
                            internal = (Scalar)child;
                            if (filterClass.getClassName().toString().equals("Twig_Filter_Function")) {
                                elemName = name.getValue().replaceAll("['\"]", "");
                                filter = new Filter(elemName);
                                filter.setInternalFunction(internal.getValue().replaceAll("['\"]", ""));
                                filter.setPhpClass(TwigIndexingVisitorExtension.this.currentClass.getName());
                                TwigIndexingVisitorExtension.this.filters.add(filter);
                            }
                        }
                        return true;
                    }
                });
            } else if (this.inTwigExtension && "getTests".equals(s.getName())) {
                phpMethod.traverse((ASTVisitor)new PHPASTVisitor(){

                    public boolean visit(ArrayElement s) throws Exception {
                        Expression key = s.getKey();
                        Expression value = s.getValue();
                        if (key == null || value == null) {
                            return false;
                        }
                        if (key.getClass() == Scalar.class && value.getClass() == ClassInstanceCreation.class) {
                            Scalar name = (Scalar)key;
                            ClassInstanceCreation functionClass = (ClassInstanceCreation)value;
                            CallArgumentsList args = functionClass.getCtorParams();
                            if (!(args.getChilds().get(0) instanceof Scalar)) {
                                return true;
                            }
                            Scalar internalFunction = (Scalar)args.getChilds().get(0);
                            if (internalFunction == null) {
                                return true;
                            }
                            if (functionClass.getClassName().toString().equals("Twig_Test_Function")) {
                                String elemName = name.getValue().replaceAll("['\"]", "");
                                JSONObject metadata = new JSONObject();
                                metadata.put((Object)"phpClass", (Object)TwigIndexingVisitorExtension.this.currentClass.getName());
                                Test test = new Test(elemName);
                                test.setPhpClass(TwigIndexingVisitorExtension.this.currentClass.getName());
                                test.setInternalFunction(internalFunction.getValue().replaceAll("['\"]", ""));
                                TwigIndexingVisitorExtension.this.tests.add(test);
                            }
                        }
                        return true;
                    }
                });
            } else if (this.inTwigExtension && "getFunctions".equals(s.getName())) {
                phpMethod.traverse((ASTVisitor)new PHPASTVisitor(){

                    public boolean visit(ArrayElement s) throws Exception {
                        Expression key = s.getKey();
                        Expression value = s.getValue();
                        if (key == null || value == null) {
                            return false;
                        }
                        if (key.getClass() == Scalar.class && value.getClass() == ClassInstanceCreation.class) {
                            Scalar name = (Scalar)key;
                            ClassInstanceCreation functionClass = (ClassInstanceCreation)value;
                            CallArgumentsList args = functionClass.getCtorParams();
                            String functionClassName = functionClass.getClassName().toString();
                            int index = -1;
                            if (functionClassName.equals("Twig_Function_Function")) {
                                index = 0;
                            } else if (functionClassName.equals("Twig_Function_Method")) {
                                index = 1;
                            }
                            if (index > -1 && args.getChilds().get(index) instanceof Scalar) {
                                Scalar internalFunction = (Scalar)args.getChilds().get(index);
                                if (internalFunction == null) {
                                    return true;
                                }
                                String elemName = name.getValue().replaceAll("['\"]", "");
                                JSONObject metadata = new JSONObject();
                                metadata.put((Object)"phpClass", (Object)TwigIndexingVisitorExtension.this.currentClass.getName());
                                Function function = new Function(elemName);
                                function.setPhpClass(TwigIndexingVisitorExtension.this.currentClass.getName());
                                function.setInternalFunction(internalFunction.getValue().replaceAll("['\"]", ""));
                                TwigIndexingVisitorExtension.this.functions.add(function);
                            }
                        }
                        return true;
                    }
                });
            } else if (this.inTokenParser && "parse".equals(s.getName())) {
                this.inTagParseMethod = true;
            } else if (this.inTokenParser && "getTag".equals(s.getName())) {
                phpMethod.traverse((ASTVisitor)new PHPASTVisitor(){

                    public boolean visit(ReturnStatement s) throws Exception {
                        if (s.getExpr().getClass() == Scalar.class) {
                            Scalar scalar = (Scalar)s.getExpr();
                            TwigIndexingVisitorExtension.this.tag.setStartTag(scalar.getValue().replaceAll("['\"]", ""));
                        }
                        return false;
                    }
                });
            }
        }
        return false;
    }

    public boolean endvisit(MethodDeclaration s) throws Exception {
        this.inTagParseMethod = false;
        return true;
    }

    public boolean visit(TypeDeclaration s) throws Exception {
        if (s instanceof ClassDeclaration) {
            this.inTwigExtension = false;
            this.currentClass = (ClassDeclaration)s;
            for (String superclass : this.currentClass.getSuperClassNames()) {
                if (superclass.equals("Twig_Extension")) {
                    this.inTwigExtension = true;
                    continue;
                }
                if (!superclass.equals("Twig_TokenParser")) continue;
                this.tag = new Tag();
                this.inTokenParser = true;
            }
            return true;
        }
        return false;
    }

    public boolean endvisit(TypeDeclaration s) throws Exception {
        if (s instanceof ClassDeclaration) {
            if (this.tag != null) {
                if (this.tag.getStartTag() != null) {
                    int length = this.currentClass.sourceEnd() - this.currentClass.sourceStart();
                    PHPDocBlock block = this.currentClass.getPHPDoc();
                    String desc = "";
                    if (block != null) {
                        String shortDesc = block.getShortDescription() != null ? block.getShortDescription() : "";
                        String longDesc = block.getLongDescription() != null ? block.getLongDescription() : "";
                        desc = String.valueOf(shortDesc) + longDesc;
                    }
                    String endTag = this.tag.getEndTag();
                    JSONObject metadata = new JSONObject();
                    metadata.put((Object)"phpClass", (Object)this.currentClass.getName());
                    metadata.put((Object)"doc", (Object)desc);
                    metadata.put((Object)"is_open_close", (Object)(endTag != null ? 1 : 0));
                    Logger.debugMSG("indexing twig tag: " + this.tag.getStartTag() + " : " + this.tag.getEndTag() + " with metadata: " + metadata.toString());
                    IIndexingRequestor.ReferenceInfo info = new IIndexingRequestor.ReferenceInfo(800, this.currentClass.sourceStart(), length, this.tag.getStartTag(), metadata.toString(), null);
                    this.addReferenceInfo(info);
                    if (endTag != null) {
                        IIndexingRequestor.ReferenceInfo endIinfo = new IIndexingRequestor.ReferenceInfo(801, this.currentClass.sourceStart(), length, this.tag.getEndTag(), metadata.toString(), null);
                        this.addReferenceInfo(endIinfo);
                    }
                }
                this.tag = null;
            }
            this.inTwigExtension = false;
            this.inTokenParser = false;
            this.currentClass = null;
        }
        return false;
    }

    public boolean visit(Statement s) throws Exception {
        if (!this.inTagParseMethod) {
            return false;
        }
        s.traverse((ASTVisitor)new PHPASTVisitor(){

            public boolean visit(PHPCallExpression callExpr) throws Exception {
                SimpleReference ref = callExpr.getCallName();
                if (ref != null && "subparse".equals(ref.getName())) {
                    callExpr.traverse((ASTVisitor)new PHPASTVisitor(){

                        public boolean visit(ArrayCreation array) throws Exception {
                            for (ArrayElement elem : array.getElements()) {
                                Expression value = elem.getValue();
                                if (value == null || value.getClass() != Scalar.class) continue;
                                Scalar scalar = (Scalar)value;
                                String subParseMethod = scalar.getValue().replaceAll("['\"]", "");
                                MethodDeclaration[] methodDeclarationArray = (this).TwigIndexingVisitorExtension.this.currentClass.getMethods();
                                int n = methodDeclarationArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    MethodDeclaration method = methodDeclarationArray[n2];
                                    if (subParseMethod.equals(method.getName())) {
                                        String[] endStatements;
                                        String[] stringArray = endStatements = TwigModelUtils.getEndStatements((PHPMethodDeclaration)method);
                                        int n3 = endStatements.length;
                                        int n4 = 0;
                                        while (n4 < n3) {
                                            String stmt = stringArray[n4];
                                            if (stmt.startsWith("end")) {
                                                (this).TwigIndexingVisitorExtension.this.tag.setEndTag(stmt);
                                                return false;
                                            }
                                            ++n4;
                                        }
                                    }
                                    ++n2;
                                }
                            }
                            return true;
                        }
                    });
                }
                return true;
            }
        });
        return true;
    }

    public boolean endvisit(Statement s) throws Exception {
        ExpressionStatement stmt;
        return s instanceof ExpressionStatement && (stmt = (ExpressionStatement)s).getExpr() instanceof PHPCallExpression;
    }

    public boolean endvisit(ModuleDeclaration s) throws Exception {
        IIndexingRequestor.ReferenceInfo info;
        PHPDocBlock doc;
        PHPMethodDeclaration phpMethod;
        for (Test test : this.tests) {
            for (MethodDeclaration method : this.methods) {
                if (!method.getName().equals(test.getInternalFunction())) continue;
                phpMethod = (PHPMethodDeclaration)method;
                doc = phpMethod.getPHPDoc();
                if (doc != null) {
                    test.addDoc(doc);
                }
                Logger.debugMSG("indexing test tag: " + test.getElementName() + " with metadata: " + test.getMetadata());
                info = new IIndexingRequestor.ReferenceInfo(804, 0, 0, test.getElementName(), test.getMetadata(), null);
                this.addReferenceInfo(info);
            }
        }
        for (Function function : this.functions) {
            for (MethodDeclaration method : this.methods) {
                if (!method.getName().equals(function.getInternalFunction())) continue;
                phpMethod = (PHPMethodDeclaration)method;
                doc = phpMethod.getPHPDoc();
                if (doc != null) {
                    function.addDoc(doc);
                }
                function.addArgs(method.getArguments());
                Logger.debugMSG("indexing function: " + function.getElementName() + " with metadata: " + function.getMetadata());
                info = new IIndexingRequestor.ReferenceInfo(803, 0, 0, function.getElementName(), function.getMetadata(), null);
                this.addReferenceInfo(info);
            }
        }
        for (Filter filter : this.filters) {
            for (MethodDeclaration method : this.methods) {
                if (!method.getName().equals(filter.getInternalFunction())) continue;
                phpMethod = (PHPMethodDeclaration)method;
                doc = phpMethod.getPHPDoc();
                if (doc != null) {
                    filter.addDoc(doc);
                }
                filter.addArgs(method.getArguments());
                Logger.debugMSG("indexing filter: " + filter.getElementName() + " with metadata: " + filter.getMetadata());
                info = new IIndexingRequestor.ReferenceInfo(802, 0, 0, filter.getElementName(), filter.getMetadata(), null);
                this.addReferenceInfo(info);
            }
        }
        return true;
    }

    protected void addReferenceInfo(IIndexingRequestor.ReferenceInfo info) {
        try {
            this.requestor.addReference(info);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public boolean visitGeneral(ASTNode node) throws Exception {
        if (node instanceof Block) {
            node.traverse((ASTVisitor)new TwigIndexingVisitor(this.requestor, this.sourceModule));
        }
        return super.visitGeneral(node);
    }
}

