/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.model;

import com.dubture.twig.core.ExtensionManager;
import com.dubture.twig.core.model.BlockName;
import com.dubture.twig.core.model.IFilter;
import com.dubture.twig.core.model.IFunction;
import com.dubture.twig.core.model.ITag;
import com.dubture.twig.core.model.ITemplateResolver;
import com.dubture.twig.core.model.ITest;
import com.dubture.twig.core.model.Template;
import com.dubture.twig.core.parser.ast.node.BlockStatement;
import com.dubture.twig.core.parser.ast.node.StringLiteral;
import com.dubture.twig.core.parser.ast.node.TwigModuleDeclaration;
import com.dubture.twig.internal.core.model.Filter;
import com.dubture.twig.internal.core.model.Function;
import com.dubture.twig.internal.core.model.Tag;
import com.dubture.twig.internal.core.model.Test;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.index2.search.ISearchRequestor;
import org.eclipse.dltk.core.index2.search.ModelAccess;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.util.LRUCache;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class TwigModelAccess {
    private static TwigModelAccess instance = null;
    private List<Template> templates = new ArrayList<Template>();
    private LRUCache tagCache = new LRUCache();

    private TwigModelAccess() {
    }

    public static TwigModelAccess getDefault() {
        if (instance == null) {
            instance = new TwigModelAccess();
        }
        return instance;
    }

    public void addTemplate(Template twigTemplate) {
        if (this.templates.contains(twigTemplate)) {
            this.templates.remove(twigTemplate);
        }
        this.templates.add(twigTemplate);
    }

    public IFunction[] getFunctions(IScriptProject scriptProject) {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        final JSONParser parser = new JSONParser();
        final ArrayList functions = new ArrayList();
        engine.search(803, null, null, 0, 0, 100, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.PREFIX, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                try {
                    JSONObject mdata;
                    Function function = new Function((ModelElement)sourceModule, elementName);
                    if (metadata != null && (mdata = (JSONObject)parser.parse((Reader)new StringReader(metadata))) != null && mdata.size() > 0) {
                        function.setPhpClass((String)mdata.get((Object)"phpClass"));
                        function.setInternalFunction((String)mdata.get((Object)"internal"));
                    }
                    functions.add(function);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, null);
        return functions.toArray(new IFunction[functions.size()]);
    }

    public IFilter[] getFilters(IScriptProject scriptProject) {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        final JSONParser parser = new JSONParser();
        final ArrayList filters = new ArrayList();
        engine.search(802, null, null, 0, 0, 100, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.PREFIX, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                try {
                    Filter filter = new Filter((ModelElement)sourceModule, elementName);
                    if (metadata != null) {
                        JSONObject mdata = (JSONObject)parser.parse((Reader)new StringReader(metadata));
                        filter.setMetadata(mdata);
                    }
                    filters.add(filter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, null);
        return filters.toArray(new IFilter[filters.size()]);
    }

    public boolean isStartTag(IScriptProject scriptProject, String text) {
        return this.isTag(scriptProject, text, 800);
    }

    public boolean isEndTag(IScriptProject scriptProject, String text) {
        return this.isTag(scriptProject, text, 801);
    }

    public boolean hasEndTag(IScriptProject scriptProject, String text) {
        IDLTKSearchScope scope = null;
        int type = 800;
        if (scriptProject != null) {
            scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
        } else {
            SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        }
        if (scope == null) {
            return false;
        }
        String cacheKey = String.valueOf(scriptProject.getElementName()) + text + type;
        if (this.tagCache.get((Object)cacheKey) != null) {
            return true;
        }
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        final JSONParser parser = new JSONParser();
        final ArrayList tags = new ArrayList();
        engine.search(type, null, text, 0, 0, 1, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.EXACT, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                try {
                    JSONObject data = (JSONObject)parser.parse((Reader)new StringReader(metadata));
                    boolean hasEnd = (Boolean)data.get((Object)"is_open_close");
                    if (hasEnd) {
                        tags.add(elementName);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, null);
        if (tags.size() == 1) {
            String tagName = (String)tags.get(0);
            cacheKey = String.valueOf(scriptProject.getElementName()) + tagName;
            this.tagCache.put((Object)cacheKey, (Object)text);
            return true;
        }
        return false;
    }

    private boolean isTag(IScriptProject scriptProject, String text, int type) {
        IDLTKSearchScope scope = null;
        scope = scriptProject != null ? SearchEngine.createSearchScope((IModelElement)scriptProject) : SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        if (scope == null) {
            return false;
        }
        String cacheKey = String.valueOf(scriptProject.getElementName()) + text + type;
        if (this.tagCache.get((Object)cacheKey) != null) {
            String cached = (String)this.tagCache.get((Object)cacheKey);
            return cached == null || cached.length() == 0;
        }
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        final ArrayList tags = new ArrayList();
        engine.search(type, null, text, 0, 0, 1, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.EXACT, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                tags.add(elementName);
            }
        }, null);
        if (tags.size() == 1) {
            String tagName = (String)tags.get(0);
            cacheKey = String.valueOf(scriptProject.getElementName()) + tagName;
            this.tagCache.put((Object)cacheKey, (Object)text);
            return true;
        }
        this.tagCache.put((Object)cacheKey, (Object)"");
        return false;
    }

    public boolean isTwigTag(IScriptProject scriptProject, String nodeName) {
        boolean isTag = this.isStartTag(scriptProject, nodeName);
        if (isTag) {
            return true;
        }
        return this.isEndTag(scriptProject, nodeName);
    }

    public void clearTagCache() {
        this.tagCache.flush();
    }

    public void clearCache() {
        this.clearTagCache();
    }

    public ITag[] findTags(IScriptProject scriptProject) {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        final ArrayList tags = new ArrayList();
        final JSONParser parser = new JSONParser();
        engine.search(800, null, null, 0, 0, 200, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.PREFIX, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                try {
                    Tag tag = new Tag(elementName);
                    if (metadata != null) {
                        JSONObject data = (JSONObject)parser.parse((Reader)new StringReader(metadata));
                        if (data.size() > 0) {
                            tag.setPhpClass((String)data.get((Object)"phpClass"));
                        }
                        if (data.size() > 1) {
                            tag.setDescription((String)data.get((Object)"doc"));
                        }
                    }
                    tags.add(tag);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, null);
        engine.search(801, null, null, 0, 0, 200, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.PREFIX, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                try {
                    Tag tag = new Tag(elementName);
                    if (metadata != null) {
                        JSONObject data = (JSONObject)parser.parse((Reader)new StringReader(metadata));
                        if (data.size() > 0) {
                            tag.setPhpClass((String)data.get((Object)"phpClass"));
                        }
                        if (data.size() > 1) {
                            tag.setDescription((String)data.get((Object)"doc"));
                        }
                    }
                    tags.add(tag);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, null);
        return tags.toArray(new ITag[tags.size()]);
    }

    public ITest[] getTests(IScriptProject scriptProject) {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        final JSONParser parser = new JSONParser();
        final ArrayList tests = new ArrayList();
        engine.search(804, null, null, 0, 0, 100, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.PREFIX, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                try {
                    Test test = new Test(elementName);
                    if (metadata != null) {
                        JSONObject mdata = (JSONObject)parser.parse((Reader)new StringReader(metadata));
                        test.setMetadata(mdata);
                    }
                    tests.add(test);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, null);
        return tests.toArray(new ITest[tests.size()]);
    }

    public String getParentPath(TwigModuleDeclaration child, IScriptProject project) {
        BlockStatement statement = child.getExtends();
        if (statement == null) {
            return null;
        }
        StringLiteral name = (StringLiteral)statement.getFirstChild();
        if (name == null) {
            return null;
        }
        return name.getValue();
    }

    public TwigModuleDeclaration getParent(TwigModuleDeclaration child, IScriptProject project) {
        TwigModuleDeclaration parent = null;
        String path = this.getParentPath(child, project);
        ITemplateResolver[] iTemplateResolverArray = ExtensionManager.getInstance().getTemplateProviders();
        int n = iTemplateResolverArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITemplateResolver iTemplateResolver = iTemplateResolverArray[n2];
            ++n2;
        }
        return parent;
    }

    public List<BlockName> findBlocks(SourceModule sourceModule, IScriptProject scriptProject) {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule);
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        final ArrayList<BlockName> blocks = new ArrayList<BlockName>();
        ISearchRequestor requestor = new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                BlockName blockName = new BlockName((IModelElement)sourceModule, elementName, offset, offset + length, offset, offset + length, "block");
                blocks.add(blockName);
            }
        };
        if (scope == null || scope.getLanguageToolkit() == null) {
            return null;
        }
        engine.search(805, null, null, 0, 0, 200, ISearchEngine.SearchFor.REFERENCES, null, scope, requestor, null);
        return blocks;
    }
}

