/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.parser.ast;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;

public class TwigAstLexer
implements Scanner {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int ST_TWIG_BLOCK_NAME = 3;
    public static final int ST_TWIG_VAR = 1;
    public static final int ST_DOUBLE_QUOTES = 4;
    public static final int YYINITIAL = 0;
    public static final int ST_BACKQUOTE = 4;
    public static final int ST_TWIG_BLOCK = 2;
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0002\u0006\u0002\u0000\u0001\u0006\u0012\u0000\u0001\f\u0001\u0000\u0001\b\u0002\u0000\u0001\u0003\u0001\u0000\u0001\u0011\u0001\u000e\u0001\u000f\u0002\u0000\u0001\r\u0001\u0000\u0001\u0007\u0001\u0000\n\u0005\u0005\u0000\u0001\n\u0001\u0000\u0001\u0004\u0001\u0010\u0010\u0004\u0001\u0004\u0007\u0004\u0001\u0000\u0001\t\u0002\u0000\u0001\u0004\u0001\u0000\u0001\u0004\u0001\u0010\u0010\u0004\u0001\u000b\u0007\u0004\u0001\u0001\u0001\u0000\u0001\u0002\u0001\u0000\u0081\u0004\uff00\u0000";
    private static final char[] ZZ_CMAP = TwigAstLexer.zzUnpackCMap("\t\u0000\u0002\u0006\u0002\u0000\u0001\u0006\u0012\u0000\u0001\f\u0001\u0000\u0001\b\u0002\u0000\u0001\u0003\u0001\u0000\u0001\u0011\u0001\u000e\u0001\u000f\u0002\u0000\u0001\r\u0001\u0000\u0001\u0007\u0001\u0000\n\u0005\u0005\u0000\u0001\n\u0001\u0000\u0001\u0004\u0001\u0010\u0010\u0004\u0001\u0004\u0007\u0004\u0001\u0000\u0001\t\u0002\u0000\u0001\u0004\u0001\u0000\u0001\u0004\u0001\u0010\u0010\u0004\u0001\u000b\u0007\u0004\u0001\u0001\u0001\u0000\u0001\u0002\u0001\u0000\u0081\u0004\uff00\u0000");
    private static final int[] ZZ_ACTION = TwigAstLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0005\u0000\u0003\u0001\u0002\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0002\u0001\u0006\u0001\u0007\u0001\u0003\u0002\u0002\u0001\u0004\u0001\b\u0001\t\u0001\u0000\u0001\n\u0001\u000b\u0001\u0000\u0001\f\u0001\u0000\u0001\r\u0003\u0000\u0001\u000e\u0001\u0001";
    private static final int[] ZZ_ROWMAP = TwigAstLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0012\u0000$\u00006\u0000H\u0000Z\u0000l\u0000~\u0000\u0090\u0000\u00a2\u0000\u00b4\u0000\u00c6\u0000\u0090\u0000\u00d8\u0000\u0090\u0000\u0090\u0000\u00ea\u0000\u00fc\u0000\u010e\u0000\u0090\u0000\u0120\u0000\u0132\u0000\u0144\u0000\u0090\u0000\u0090\u0000\u0156\u0000\u0090\u0000\u00d8\u0000\u0090\u0000\u0168\u0000\u00fc\u0000\u017a\u0000\u0090\u0000\u0090";
    private static final int[] ZZ_TRANS = TwigAstLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0006\u0001\u0007\n\u0006\u0001\b\u0005\u0006\u0002\t\u0001\n\u0001\t\u0001\u000b\u0001\t\u0001\f\u0001\r\u0001\u000e\u0002\t\u0001\u000b\u0001\f\u0001\t\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0003\t\u0001\u0013\u0001\u000b\u0001\t\u0001\f\u0001\r\u0001\u000e\u0002\t\u0001\u000b\u0001\f\u0001\u0014\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0004\t\u0001\u0015\u0001\t\u0001\u0016\u0001\r\u0003\t\u0001\u0015\u0001\u0016\u0003\t\u0001\u0015\u0013\t\u0001\u0006\u0001\u0017\u0011\u0006\u0001\u0018\u0001\u0006\u0001\u0019\u0006\u0006\u0002\u0000\u0007\u0006\u0001\u001a\u0010\u0006\u0014\u0000\u0001\u001b\u0013\u0000\u0002\u000b\u0005\u0000\u0001\u000b\u0004\u0000\u0001\u000b\u0007\u0000\u0001\f\u0005\u0000\u0001\f\u0005\u0000\b\u001c\u0001\u001d\u0001\u001e\b\u001c\u0004\u0000\u0002\u000b\u0002\u0000\u0001\u001c\u0002\u0000\u0001\u000b\u0004\u0000\u0001\u000b\n\u001f\u0001 \u0007\u001f\u0001\u001d\u0002\u0000\u0001!\u0013\u0000\u0002\u0015\u0005\u0000\u0001\u0015\u0004\u0000\u0001\u0015\u0007\u0000\u0001\u0016\u0005\u0000\u0001\u0016\u0005\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0006\u0006\u0002\u0000\u0007\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0006\u0006\u0001\u0000\u0001\"\u0006\u0006\u0007\u0000\u0001\u001c\u0011\u0000\u0001\u001f\n\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = TwigAstLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0005\u0000\u0003\u0001\u0001\t\u0003\u0001\u0001\t\u0001\u0001\u0002\t\u0003\u0001\u0001\t\u0002\u0001\u0001\u0000\u0002\t\u0001\u0000\u0001\t\u0001\u0000\u0001\t\u0003\u0000\u0002\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;

    private static int[] zzUnpackAction() {
        int[] result = new int[34];
        int offset = 0;
        offset = TwigAstLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[34];
        int offset = 0;
        offset = TwigAstLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[396];
        int offset = 0;
        offset = TwigAstLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[34];
        int offset = 0;
        offset = TwigAstLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    protected int getTokenStartPosition() {
        return this.zzStartRead - this.zzPushbackPos;
    }

    protected int getTokenLength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private Symbol symbol(int type) {
        int leftPosition = this.getTokenStartPosition();
        return new Symbol(type, leftPosition, leftPosition + this.getTokenLength());
    }

    private Symbol fullSymbol(int type) {
        Symbol symbol = this.symbol(type);
        symbol.value = this.yytext();
        return symbol;
    }

    public boolean isEOF() {
        return this.zzAtEOF;
    }

    public TwigAstLexer(Reader in) {
        this.zzReader = in;
    }

    public TwigAstLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 88) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() throws IOException {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
            this.yyclose();
        }
    }

    public Symbol next_token() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block32: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            boolean zzR = false;
            int zzCurrentPosL = this.zzStartRead;
            while (zzCurrentPosL < zzMarkedPosL) {
                switch (zzBufferL[zzCurrentPosL]) {
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        ++this.yyline;
                        zzR = false;
                        break;
                    }
                    case '\r': {
                        ++this.yyline;
                        zzR = true;
                        break;
                    }
                    case '\n': {
                        if (zzR) {
                            zzR = false;
                            break;
                        }
                        ++this.yyline;
                        break;
                    }
                    default: {
                        zzR = false;
                    }
                }
                ++zzCurrentPosL;
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    boolean eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 12: {
                    this.yybegin(0);
                    return this.symbol(3);
                }
                case 15: {
                    continue block32;
                }
                case 8: {
                    this.yybegin(2);
                    return this.fullSymbol(11);
                }
                case 16: {
                    continue block32;
                }
                case 5: 
                case 17: {
                    continue block32;
                }
                case 13: {
                    return this.fullSymbol(10);
                }
                case 18: {
                    continue block32;
                }
                case 2: {
                    System.out.print(this.yytext());
                }
                case 19: {
                    continue block32;
                }
                case 14: {
                    this.yybegin(0);
                    return this.symbol(5);
                }
                case 20: {
                    continue block32;
                }
                case 6: {
                    return this.symbol(6);
                }
                case 21: {
                    continue block32;
                }
                case 7: {
                    return this.symbol(7);
                }
                case 22: {
                    continue block32;
                }
                case 3: {
                    return this.fullSymbol(9);
                }
                case 23: {
                    continue block32;
                }
                case 9: 
                case 24: {
                    continue block32;
                }
                case 11: {
                    this.yybegin(3);
                    return this.symbol(4);
                }
                case 25: {
                    continue block32;
                }
                case 1: {
                    return this.symbol(8);
                }
                case 26: {
                    continue block32;
                }
                case 10: {
                    this.yybegin(1);
                    return this.symbol(2);
                }
                case 27: {
                    continue block32;
                }
                case 4: 
                case 28: {
                    continue block32;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                return new Symbol(0);
            }
            this.zzScanError(1);
        }
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.out.println("Usage : java TwigAstLexer <inputfile>");
        } else {
            int i = 0;
            while (i < argv.length) {
                TwigAstLexer scanner = null;
                try {
                    scanner = new TwigAstLexer(new FileReader(argv[i]));
                    while (!scanner.zzAtEOF) {
                        scanner.next_token();
                    }
                }
                catch (FileNotFoundException e) {
                    System.out.println("File not found : \"" + argv[i] + "\"");
                }
                catch (IOException e) {
                    System.out.println("IO error scanning file \"" + argv[i] + "\"");
                    System.out.println(e);
                }
                catch (Exception e) {
                    System.out.println("Unexpected exception:");
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }
}

