/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.parser.ast.node;

import com.dubture.twig.core.parser.ast.node.BlockName;
import com.dubture.twig.core.parser.ast.node.Variable;
import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.statements.Statement;

public class BlockStatement
extends Statement {
    protected final BlockName name;
    private final List<Statement> statements;

    public BlockStatement(int startIndex, int stopIndex, BlockName name2, List<Statement> statements) {
        super(startIndex, stopIndex);
        this.name = name2;
        this.statements = statements;
    }

    public BlockName getName() {
        return this.name;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Statement)this);
        if (visit) {
            this.name.traverse(visitor);
            if (this.statements != null) {
                for (Statement exp : this.statements) {
                    exp.traverse(visitor);
                }
            }
        }
        visitor.endvisit((Statement)this);
    }

    public Statement getFirstChild() {
        if (this.statements != null && this.statements.size() > 0) {
            return this.statements.get(0);
        }
        return null;
    }

    public List getChilds() {
        return this.statements;
    }

    public Variable getBlockName() {
        Statement first = this.getFirstChild();
        if (first == null) {
            return null;
        }
        Statement statement = first;
        if (statement instanceof Variable) {
            return (Variable)statement;
        }
        return null;
    }

    public int getKind() {
        return 101;
    }

    public boolean isBlock() {
        if (this.name == null) {
            return false;
        }
        return "block".equals(this.name.getValue());
    }

    public boolean isExtends() {
        if (this.name == null) {
            return false;
        }
        return "extends".equals(this.name.getValue());
    }

    public String getTag() {
        BlockName name = this.getName();
        if (name == null) {
            return "";
        }
        return name.getValue();
    }
}

