/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.parser.ast.node;

import com.dubture.twig.core.parser.ast.node.BlockName;
import com.dubture.twig.core.parser.ast.node.BlockStatement;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.statements.Statement;

public class TwigModuleDeclaration
extends ModuleDeclaration {
    protected List<BlockStatement> blocks;

    public TwigModuleDeclaration(int length, List<Statement> statements) {
        super(length);
        for (Statement statement : statements) {
            this.addStatement((ASTNode)statement);
        }
    }

    public List<BlockStatement> getBlocks() {
        if (this.blocks != null) {
            return this.blocks;
        }
        this.blocks = new LinkedList<BlockStatement>();
        for (Object o : this.getStatements()) {
            if (!(o instanceof BlockStatement)) continue;
            this.blocks.add((BlockStatement)((Object)o));
        }
        return this.blocks;
    }

    public BlockStatement getExtends() {
        for (BlockStatement block : this.getBlocks()) {
            BlockName name = block.getName();
            if (name == null || !"extends".equals(name.getValue())) continue;
            return block;
        }
        return null;
    }
}

