/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.search;

import com.dubture.twig.core.log.Logger;
import com.dubture.twig.core.parser.ast.node.TwigModuleDeclaration;
import com.dubture.twig.core.parser.ast.visitor.TwigASTVisitor;
import org.eclipse.dltk.ast.ASTNode;

public class NodeFinder {
    public static ASTNode perform(TwigModuleDeclaration astRoot, int offset, int length) {
        try {
            AstNodeFinder finder = new AstNodeFinder(offset, length);
            astRoot.traverse(finder);
            return finder.fCoveringNode;
        }
        catch (Exception e) {
            Logger.logException(e);
            return null;
        }
    }

    private static class AstNodeFinder
    extends TwigASTVisitor {
        private int fStart;
        private int fEnd;
        private ASTNode fCoveringNode;
        private ASTNode fCoveredNode;

        public AstNodeFinder(int offset, int length) {
            this.fStart = offset;
            this.fEnd = offset + length;
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            int nodeStart = node.sourceStart();
            int nodeEnd = node.sourceEnd();
            if (nodeEnd < this.fStart || this.fEnd < nodeStart) {
                return false;
            }
            if (nodeStart <= this.fStart && this.fEnd <= nodeEnd) {
                this.fCoveringNode = node;
            }
            if (this.fStart <= nodeStart && nodeEnd <= this.fEnd) {
                if (this.fCoveringNode == node) {
                    this.fCoveredNode = node;
                    return true;
                }
                if (this.fCoveredNode == null) {
                    this.fCoveredNode = node;
                }
                return false;
            }
            return true;
        }
    }
}

