/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.util;

import com.dubture.twig.core.documentModel.provisional.contenttype.ContentTypeIdForTwig;
import com.dubture.twig.core.log.Logger;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.php.core.compiler.ast.nodes.ArrayCreation;
import org.eclipse.php.core.compiler.ast.nodes.ArrayElement;
import org.eclipse.php.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.ReturnStatement;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;

public class TwigModelUtils {
    public static boolean isTwigTemplate(String filename) {
        IContentType[] contentTypes;
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType[] iContentTypeArray = contentTypes = manager.findContentTypesFor(filename);
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType type = iContentTypeArray[n2];
            if (ContentTypeIdForTwig.CONTENT_TYPE_ID_TWIG.equals(type.getId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isTwigTemplate(IResource resource) {
        assert (resource != null);
        if (resource.getType() != 1) {
            return false;
        }
        try {
            return ((IFile)resource).getContentDescription().getContentType().isKindOf(Platform.getContentTypeManager().getContentType(ContentTypeIdForTwig.CONTENT_TYPE_ID_TWIG));
        }
        catch (CoreException e) {
            Logger.logException(e);
            return false;
        }
    }

    public static String[] getEndStatements(PHPMethodDeclaration method) {
        final ArrayList statements = new ArrayList();
        try {
            method.traverse((ASTVisitor)new PHPASTVisitor(){

                public boolean visit(ReturnStatement s) throws Exception {
                    if (s.getExpr() instanceof PHPCallExpression) {
                        PHPCallExpression call = (PHPCallExpression)s.getExpr();
                        CallArgumentsList args = call.getArgs();
                        if ("test".equals(call.getName()) && args.getChilds().size() == 1) {
                            Object arg = args.getChilds().get(0);
                            if (arg instanceof Scalar) {
                                Scalar scalar = (Scalar)arg;
                                statements.add(scalar.getValue().replaceAll("['\"]", ""));
                            } else if (arg instanceof ArrayCreation) {
                                ArrayCreation array = (ArrayCreation)arg;
                                for (ArrayElement key : array.getElements()) {
                                    Expression value = key.getValue();
                                    if (value == null || !(value instanceof Scalar)) continue;
                                    Scalar scalar = (Scalar)value;
                                    statements.add(scalar.getValue().replaceAll("['\"]", ""));
                                }
                            }
                        }
                    }
                    return false;
                }
            });
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return statements.toArray(new String[statements.size()]);
    }
}

