/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.twig.core.util.text;

import com.dubture.twig.core.documentModel.parser.regions.ITwigScriptRegion;
import com.dubture.twig.core.log.Logger;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.php.internal.core.util.text.TextSequenceUtilities;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class TwigTextSequenceUtilities {
    public static TextSequence getStatement(int offset, IStructuredDocumentRegion sdRegion, boolean removeComments) {
        int documentOffset = offset;
        if (documentOffset == sdRegion.getEndOffset()) {
            --documentOffset;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(documentOffset);
        IStructuredDocumentRegion container = sdRegion;
        if (tRegion instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
        }
        if (tRegion != null && tRegion.getType() == "TWIG_CLOSE") {
            tRegion = container.getRegionAtCharacterOffset(container.getStartOffset() + tRegion.getStart() - 1);
        }
        if (tRegion != null && TwigTextSequenceUtilities.isTwigRegion(tRegion.getType())) {
            ITwigScriptRegion twigScriptRegion = (ITwigScriptRegion)tRegion;
            try {
                int startOffset = container.getStartOffset() + twigScriptRegion.getStart();
                ITextRegion startTokenRegion = documentOffset == startOffset ? twigScriptRegion.getTwigToken(0) : twigScriptRegion.getTwigToken(offset - startOffset - 1);
                while (startTokenRegion.getStart() != 0) {
                    if (startTokenRegion.getType() == "PHP_CURLY_CLOSE" || startTokenRegion.getType() == "PHP_CURLY_OPEN" || startTokenRegion.getType() == "PHP_SEMICOLON") {
                        startOffset += startTokenRegion.getEnd();
                        break;
                    }
                    startTokenRegion = twigScriptRegion.getTwigToken(startTokenRegion.getStart() - 1);
                }
                TextSequence textSequence = TextSequenceUtilities.createTextSequence((IStructuredDocumentRegion)sdRegion, (int)startOffset, (int)(offset - startOffset));
                textSequence = textSequence.subTextSequence(PHPTextSequenceUtilities.readForwardSpaces((CharSequence)textSequence, (int)0), textSequence.length());
                return textSequence;
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        return null;
    }

    private static boolean isTwigRegion(String context) {
        return context == "TWIG_CONTENT" || context == "TWIG_COMMENT";
    }

    public static int readIdentifierStartIndex(TextSequence textSequence, int startPosition) {
        while (startPosition > 0) {
            char ch = textSequence.charAt(startPosition - 1);
            if (!Character.isLetterOrDigit(ch) && ch != '_') break;
            --startPosition;
        }
        return startPosition;
    }

    public static boolean isInFunction(TextSequence statement) {
        int startOffset = statement.length() - 1;
        int quotesCount = 0;
        while (startOffset > 0) {
            char ch = statement.charAt(startOffset);
            if (ch == '(') {
                return true;
            }
            if ((ch == '\'' || ch == '\"') && quotesCount++ > 0) {
                return false;
            }
            --startOffset;
        }
        return false;
    }

    public static boolean isInField(TextSequence statement) {
        int startOffset = statement.length() - 1;
        while (startOffset > 0) {
            char ch = statement.charAt(startOffset);
            if (ch == '(') {
                return false;
            }
            if (ch == '.') {
                return true;
            }
            --startOffset;
        }
        return false;
    }

    public static String getVariable(TextSequence statement) {
        int startOffset = statement.length() - 1;
        int dotOffset = -1;
        while (startOffset > 0) {
            char current = statement.charAt(startOffset);
            if (current == '.') {
                dotOffset = startOffset;
            }
            if (dotOffset > -1 && Character.isWhitespace(current)) break;
            --startOffset;
        }
        if (dotOffset > -1) {
            return statement.toString().substring(startOffset, dotOffset).toString();
        }
        return null;
    }
}

